package ru.yandex.autotests.directapi.changes.checkcampaigns;

import com.yandex.direct.api.v5.changes.CampaignChangesInEnum;
import com.yandex.direct.api.v5.changes.CampaignChangesItem;
import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.date.DBTimeConverter;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.changes.CampaignChangesItemMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by alexteut on 20.10.16.
 * https://st.yandex-team.ru/TESTIRT-10468
 */

@Aqua.Test
@Features(ChangesFeatures.CHECK_CAMPAIGNS)
@Issue("https://st.yandex-team.ru/DIRECT-40604")
@Description("Попадает ли в changes остановка кампании.")
@Tag(TagDictionary.TRUNK)
public class CheckCampaignsStopResumeWithTimestampTest {
    private static final String СLIENT = ChangesLogins.CHANGES_CLIENT2;
    private static final DateTime LAST_CHANGE = DateTime.now().minusMonths(1);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(СLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignId;
    private static String timestampBeforeStop;

    @BeforeClass
    public static void prepareData(){
        timestampBeforeStop = api.userSteps.changesSteps().getTimestamp();
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Before
    public void setUp() {
        api.userSteps.changesSteps().setUseCampAggregatedLastChange(false);
    }

    @Test
    public void checkStopCampaign() {
        setLastChange(campaignId, LAST_CHANGE);
        api.userSteps.campaignSteps().campaignsSuspend(campaignId);

        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestampBeforeStop)
                );

        CampaignChangesItemMap expectedCampaignItems = new CampaignChangesItemMap()
                .withCampaignId(campaignId)
                .withChangesIn(CampaignChangesInEnum.SELF);
        assertThat("CampaignStop попадает в Changes",
                actualCampaignsResponse.getCampaigns(),
                hasItem(beanDiffer((CampaignChangesItem) expectedCampaignItems.getBean()))
        );
    }

    @Test
    public void checkResumeCampaign() {
        api.userSteps.campaignSteps().campaignsSuspend(campaignId);
        setLastChange(campaignId, LAST_CHANGE);
        api.userSteps.campaignSteps().campaignsResume(campaignId);

        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestampBeforeStop)
                );

        CampaignChangesItemMap expectedCampaignItems = new CampaignChangesItemMap()
                .withCampaignId(campaignId)
                .withChangesIn(CampaignChangesInEnum.SELF);
        assertThat("CampaignResume попадает в Changes",
                actualCampaignsResponse.getCampaigns(),
                hasItem(beanDiffer((CampaignChangesItem) expectedCampaignItems.getBean()))
        );
    }

    private static void setLastChange(Long campaignId, DateTime time) {
        api.userSteps.campaignFakeSteps()
                .setLastChange(campaignId, DBTimeConverter.jodaTimeToDb(time));
    }
}
