package ru.yandex.autotests.directapi.changes.checkcampaigns;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 03.04.15.
 * https://st.yandex-team.ru/TESTIRT-4917
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK_CAMPAIGNS)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
public class CheckCampaignsUnitsTest {
    private static LogSteps log = LogSteps.getLogger(CheckCampaignsUnitsTest.class);
    int CHECK_CAMPAIGNS_COST = 10;
    int DEFAULT_ERROR_COST = 20;
    int COMMON_ERROR_COST = 50;
    private String paramsString = "params";

    private static String login = ChangesLogins.CAMPAIGNS_UNITS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    private String timestamp;

    @Before
    @Step("подготовка логина")
    public void clearSpentUnits() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        api.as(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3506")
    public void callChangesCheckWithValidParams(){
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(login);
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(login);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CHECK_CAMPAIGNS_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3504")
    public void callChangesCheckWithInvalidParams(){
        //DIRECT-40769
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(login);
        api.userSteps.changesSteps().shouldGetErrorOnCheckCampaigns(
                new CheckCampaignsRequestMap()
                        .withTimestamp(""),
                JavaOrPerlApi5Error
                        .java(new Api5Error(4000,
                                Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
                        .perl(new Api5Error(4000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(login);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(DEFAULT_ERROR_COST + CHECK_CAMPAIGNS_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3505")
    public void callChangesCheckWithoutParams(){
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(login);
        api.userSteps.changesSteps().shouldGetErrorOnCheckCampaigns(
                new CheckCampaignsRequestMap(),
                JavaOrPerlApi5Error
                        .java(new Api5Error(8000,
                                Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
                        .perl(new Api5Error(8000,
                                Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                                paramsString,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(login);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(COMMON_ERROR_COST));
    }


}
