package ru.yandex.autotests.directapi.changes.checkcampaigns;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.changes.CampaignChangesInEnum;
import com.yandex.direct.api.v5.changes.CampaignChangesItem;
import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.changes.CampaignChangesItemMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 31.03.15.
 * https://st.yandex-team.ru/TESTIRT-4917
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK_CAMPAIGNS)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка доступа ролей к методу.")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class RolesAccessPositiveTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public String loginForAuth;

    @Parameterized.Parameter(1)
    public String login;

    @Parameterized.Parameters(name = "loginForAuth = {0}, login = {1}")
    public static Collection testLogins() {
        Object[][] data = new Object[][]{
                {Logins.MANAGER_DEFAULT, ChangesLogins.SERVICED_CLIENT_IN_2_SHARD},
                {Logins.PLACER, ChangesLogins.CHANGES_CLIENT},
                {Logins.SUPPORT,ChangesLogins.CHANGES_CLIENT},
                {Logins.SUPER_LOGIN,ChangesLogins.CHANGES_CLIENT},
                {Logins.MEDIA,ChangesLogins.CHANGES_CLIENT},
                {Logins.SUPER_READER,ChangesLogins.CHANGES_CLIENT},
                {ChangesLogins.CHANGES_CLIENT,ChangesLogins.CHANGES_CLIENT},
                {ChangesLogins.AGENCY_CAMPAIGNS,ChangesLogins.SUB_CLIENT_WITH_EDIT_RIGHTS}
        };
        return Arrays.asList(data);
    }

    @Before
    public void setUp() {
        api.userSteps.changesSteps().setUseCampAggregatedLastChange(false);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3508")
    public void callChangesCheckCampaigns(){
        String timestamp = api.as(loginForAuth).userSteps.changesSteps().getTimestamp(login);
        Long campaignId = api.as(login).userSteps.campaignSteps().addDefaultTextCampaign(login);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        CheckCampaignsResponse actualCampaignsResponse =
                api.as(loginForAuth).userSteps.changesSteps().withUseCampAggregatedLastChange(false).changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp),
                        login
                );
        CampaignChangesItemMap expectedCampaignItems = new CampaignChangesItemMap()
                .withCampaignId((long)campaignId)
                .withChangesIn(
                        CampaignChangesInEnum.SELF,
                        CampaignChangesInEnum.CHILDREN);
        assertThat("вернулись корректные значения",
                actualCampaignsResponse.getCampaigns(),
                hasItem(beanDiffer((CampaignChangesItem) expectedCampaignItems.getBean())));
    }
}
