package ru.yandex.autotests.directapi.changes.checkdictionaries;

import com.yandex.direct.api.v5.changes.CheckDictionariesResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.changes.CheckDictionariesRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by ginger on 03.04.15.
 * https://st.yandex-team.ru/TESTIRT-4915
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK_DICTIONARIES)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка доступа ролей к методу.")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CheckDictionariesRoleAccessTest {
    private static LogSteps log = LogSteps.getLogger(CheckDictionariesRoleAccessTest.class);

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public String loginForAuth;

    @Parameterized.Parameter(1)
    public String login;

    @Parameterized.Parameters(name = "loginForAuth = {0}, login = {1}")
    public static Collection testLogins() {
        Object[][] data = new Object[][]{
                {Logins.MANAGER_DEFAULT,Logins.CLIENT_FREE_YE_DEFAULT},
                {Logins.PLACER,ChangesLogins.CHANGES_CLIENT},
                {Logins.SUPPORT,ChangesLogins.CHANGES_CLIENT},
                {Logins.SUPER_LOGIN,ChangesLogins.CHANGES_CLIENT},
                {Logins.MEDIA,ChangesLogins.CHANGES_CLIENT},
                {Logins.SUPER_READER,ChangesLogins.CHANGES_CLIENT},
                {ChangesLogins.CHANGES_CLIENT,ChangesLogins.CHANGES_CLIENT},

                {Logins.AGENCY_1_CAMPAIGNS, null},
                {Logins.AGENCY_1_CAMPAIGNS, Logins.AGENCY_1_CAMPAIGNS},
                {Logins.AGENCY_1_CAMPAIGNS, Logins.SUBCLIENT_CAMPAIGNS},
                {Logins.CLIENT_IN_2_SHARD, null},
                {Logins.CLIENT_IN_2_SHARD, Logins.CLIENT_IN_2_SHARD},
                {Logins.MEDIA, null},
                {Logins.SUPER_LOGIN, null},
                {Logins.SUPER_READER, null},
                {Logins.SUPPORT, null},
                {Logins.PLACER, null},
                {Logins.MANAGER_DEFAULT, null},
                {Logins.SUB_CLIENT_WITH_EDIT_RIGHTS, null},
                {Logins.SERVICED_CLIENT_IN_2_SHARD, null}
        };
        return Arrays.asList(data);
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3519")
    public void callChangesCheckDictionaries(){
        String timestamp = api.as(loginForAuth).userSteps.changesSteps().getTimestamp(login);
        CheckDictionariesResponse actualCheckDictionariesResponse =
                api.as(loginForAuth).userSteps.changesSteps().changesCheckDictionaries(
                        new CheckDictionariesRequestMap()
                                .withTimestamp(timestamp),
                        login
                );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckDictionariesRequestMap.TIMESTAMP).useMatcher(notNullValue());
        CheckDictionariesResponse expectedCheckDictionariesResponse = new CheckDictionariesResponse();
        expectedCheckDictionariesResponse.setRegionsChanged(YesNoEnum.NO);
        expectedCheckDictionariesResponse.setTimeZonesChanged(YesNoEnum.NO);
        assertThat("вернулись корректные поля", actualCheckDictionariesResponse,
                beanEquivalent(expectedCheckDictionariesResponse).withVariation(variation));
    }
}
