package ru.yandex.autotests.directapi.changes.checkdictionaries;

import com.yandex.direct.api.v5.changes.CheckDictionariesResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.changes.CheckDictionariesRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by ginger on 25.03.15.
* https://st.yandex-team.ru/TESTIRT-4915
*/
@Features(ChangesFeatures.SMOKE)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка некорректных входных данных.")
public class CheckDictionariesSmokeTest {
    private static LogSteps log = LogSteps.getLogger(CheckDictionariesSmokeTest.class);

    private static String login = ChangesLogins.CHANGES_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3520")
    public void callChangesCheckDictionaries(){
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        CheckDictionariesResponse actualCheckDictionariesResponse =
                api.userSteps.changesSteps().changesCheckDictionaries(
                    new CheckDictionariesRequestMap()
                    .withTimestamp(timestamp)
        );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckDictionariesRequestMap.TIMESTAMP).useMatcher(notNullValue());
        CheckDictionariesResponse expectedCheckDictionariesResponse = new CheckDictionariesResponse();
        expectedCheckDictionariesResponse.setRegionsChanged(YesNoEnum.NO);
        expectedCheckDictionariesResponse.setTimeZonesChanged(YesNoEnum.NO);
        assertThat("вернулись корректные поля", actualCheckDictionariesResponse,
                beanEquivalent(expectedCheckDictionariesResponse).withVariation(variation));
    }
}
