package ru.yandex.autotests.directapi.changes.checkdictionaries;

import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.changes.CheckDictionariesRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.*;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 02.04.15.
 * https://st.yandex-team.ru/TESTIRT-4915
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK_DICTIONARIES)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка списания баллов за операцию.")
public class CheckDictionariesUnitsTest {
    private static LogSteps log = LogSteps.getLogger(CheckDictionariesUnitsTest.class);
    int CHECK_DICTIONARIES_COST = 10;
    int DEFAULT_ERROR_COST = 20;
    int COMMON_ERROR_COST = 50;
    private String paramsString = "params";

    private static String login = ChangesLogins.DICTIONARIES_UNITS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Before
    @Step("подготовка логина")
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        api.as(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3521")
    public void successCallChangesCheckDictionaries(){
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(login);
        api.userSteps.changesSteps().changesCheckDictionaries(
                new CheckDictionariesRequestMap().withTimestamp(timestamp));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(login);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CHECK_DICTIONARIES_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3522")
    public void callChangesCheckDictionariesWithInvalidParams(){
        //DIRECT-40769
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(login);
        api.userSteps.changesSteps().shouldGetErrorOnCheckDictionaries(
                new CheckDictionariesRequestMap()
                        .withTimestamp(DateTime.now().toDate().toString()),
                JavaOrPerlApi5Error
                        .java(new Api5Error(4000,
                                Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(CheckRequestMap.TIMESTAMP)))
                        .perl(new Api5Error(4000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(CheckRequestMap.TIMESTAMP)))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(login);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(DEFAULT_ERROR_COST + CHECK_DICTIONARIES_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3523")
    public void callChangesCheckDictionariesWithoutParams(){
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(login);
        api.userSteps.changesSteps().shouldGetJSONErrorOn(ServiceNames.CHANGES, null, Action.CHECK_DICTIONARIES,
                null,
                JavaOrPerlApi5Error
                        .java(new Api5Error(8000, Api5ErrorDetailsJava.INVALID_REQUEST_FORMAT, paramsString))
                        .perl(new Api5Error(8000, Api5ErrorDetails.FIELD_CANNOT_HAVE_VALUE, paramsString, null))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(login);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(COMMON_ERROR_COST));
    }
}
