package ru.yandex.autotests.directapi.clients.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

@Aqua.Test
@Features(ClientsFeatures.GET)
@Description("Проверки запрещённых для агенства полей")
@RunWith(Parameterized.class)
public class FieldNamesValidationAgencyNegativeTest {
    private static final String LOGIN = Logins.LOGIN_AGENCY;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @BeforeClass
    public static void clear() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Parameterized.Parameter
    public ClientFieldEnum fieldName;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {ClientFieldEnum.ACCOUNT_QUALITY},
                {ClientFieldEnum.CURRENCY},
                {ClientFieldEnum.GRANTS},
                {ClientFieldEnum.OVERDRAFT_SUM_AVAILABLE},
                {ClientFieldEnum.RESTRICTIONS},
                {ClientFieldEnum.SETTINGS},
        });

    }

    @Test
    public void forbiddenFieldNameTest() {
        api.userSteps.clientsStepsV5().expectErrorOnClientsGet(
                new GetRequestMap().withFieldNames(fieldName),
                LOGIN,
                new Api5Error(8000, Api5ErrorDetailsJava.FORBIDDEN_AGENCY_FIELDS_ONLY)
        );
    }
}
