package ru.yandex.autotests.directapi.clients.get;

import java.util.Arrays;
import java.util.Collection;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import com.yandex.direct.api.v5.clients.GetResponse;
import com.yandex.direct.api.v5.generalclients.ClientGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientBaseItemMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.CompareStrategy;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.greaterThanOrEqualTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath.newPath;

/**
 * Created by buhter on 10/02/16.
 * https://st.yandex-team.ru/TESTIRT-8440
 */
@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-49746")
@Description("Проверки поля FieldNames")
@RunWith(Parameterized.class)
public class FieldNamesValidationTest {
    private static final String LOGIN = Logins.LOGIN_MAIN;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void clear() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public ClientFieldEnum[] fieldNames;

    @Parameterized.Parameter(2)
    public CompareStrategy strategy;

    private static BeanFieldPath firstItemFieldPath(String fieldName) {
        return newPath("0/".concat(fieldName));
    }

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Все поля", ClientFieldEnum.values()
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(".+"))
                        .useMatcher(allOf(notNullValue(), not(empty())))},
                {ClientFieldEnum.CLIENT_ID.value(), new ClientFieldEnum[]{ClientFieldEnum.CLIENT_ID}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.CLIENT_ID))
                        .useMatcher(notNullValue())},
                {ClientFieldEnum.COUNTRY_ID.value(), new ClientFieldEnum[]{ClientFieldEnum.COUNTRY_ID}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.COUNTRY_ID))
                        .useMatcher(notNullValue())},
                {ClientFieldEnum.ARCHIVED.value(), new ClientFieldEnum[]{ClientFieldEnum.ARCHIVED}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.ARCHIVED))
                        .useMatcher(notNullValue())},
                {ClientFieldEnum.ACCOUNT_QUALITY.value(), new ClientFieldEnum[]{ClientFieldEnum.ACCOUNT_QUALITY}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.ACCOUNT_QUALITY))
                        .useMatcher(instanceOf(JAXBElement.class))},
                {ClientFieldEnum.CREATED_AT.value(), new ClientFieldEnum[]{ClientFieldEnum.CREATED_AT}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.CREATED_AT))
                        .useMatcher(notNullValue())},
                {ClientFieldEnum.CURRENCY.value(), new ClientFieldEnum[]{ClientFieldEnum.CURRENCY}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.CURRENCY))
                        .useMatcher(notNullValue())},
                {ClientFieldEnum.CLIENT_INFO.value(), new ClientFieldEnum[]{ClientFieldEnum.CLIENT_INFO}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientBaseItemMap.CLIENT_INFO))
                        .useMatcher(notNullValue())},
                {ClientFieldEnum.GRANTS.value(), new ClientFieldEnum[]{ClientFieldEnum.GRANTS}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.GRANTS))
                        .useMatcher(hasSize(greaterThanOrEqualTo(0)))},
                {ClientFieldEnum.BONUSES.value(), new ClientFieldEnum[]{ClientFieldEnum.BONUSES}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.BONUSES))
                        .useMatcher(notNullValue())},
                {ClientFieldEnum.RESTRICTIONS.value(), new ClientFieldEnum[]{ClientFieldEnum.RESTRICTIONS}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.RESTRICTIONS))
                        .useMatcher(hasSize(greaterThanOrEqualTo(0)))},
                {ClientFieldEnum.LOGIN.value(), new ClientFieldEnum[]{ClientFieldEnum.LOGIN}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.LOGIN))
                        .useMatcher(notNullValue())},
                {ClientFieldEnum.NOTIFICATION.value(), new ClientFieldEnum[]{ClientFieldEnum.NOTIFICATION}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.NOTIFICATION))
                        .useMatcher(notNullValue())},
                {ClientFieldEnum.OVERDRAFT_SUM_AVAILABLE.value(),
                        new ClientFieldEnum[]{ClientFieldEnum.OVERDRAFT_SUM_AVAILABLE}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.OVERDRAFT_SUM_AVAILABLE))
                        .useMatcher(notNullValue())},
                {ClientFieldEnum.PHONE.value(), new ClientFieldEnum[]{ClientFieldEnum.PHONE}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientBaseItemMap.PHONE))
                        .useMatcher(notNullValue(JAXBElement.class))},
                {ClientFieldEnum.REPRESENTATIVES.value(), new ClientFieldEnum[]{ClientFieldEnum.REPRESENTATIVES}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.REPRESENTATIVES))
                        .useMatcher(hasSize(greaterThanOrEqualTo(0)))},
                {ClientFieldEnum.SETTINGS.value(), new ClientFieldEnum[]{ClientFieldEnum.SETTINGS}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.SETTINGS))
                        .useMatcher(hasSize(greaterThanOrEqualTo(0)))},
                {ClientFieldEnum.VAT_RATE.value(), new ClientFieldEnum[]{ClientFieldEnum.VAT_RATE}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.VAT_RATE))
                        .useMatcher(instanceOf(JAXBElement.class))},
                {ClientFieldEnum.TYPE.value(), new ClientFieldEnum[]{ClientFieldEnum.TYPE}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.TYPE))
                        .useMatcher(notNullValue())},
                {"Два поля", new ClientFieldEnum[]{ClientFieldEnum.CREATED_AT, ClientFieldEnum.CURRENCY}
                        , DefaultCompareStrategies
                        .allFields()
                        .forFields(firstItemFieldPath(ClientGetItemMap.CREATED_AT),
                                firstItemFieldPath(ClientGetItemMap.CURRENCY))
                        .useMatcher(notNullValue())},
        });

    }

    @Test
    public void fieldNamesTestJSON() {
        GetResponse getResponse
                = api.protocol(ProtocolType.JSON).as(LOGIN).userSteps.clientsStepsV5()
                .clientsGet(new GetRequestMap().withFieldNames(fieldNames));
        assertThat("в ответе массив с одним объектом и запрошенными полями в нем", getResponse.getClients()
                , beanDiffer(Arrays.asList(new ClientGetItem())).useCompareStrategy(strategy));
    }

    @Test
    public void fieldNamesTestSOAP() {
        GetResponse getResponse
                = api.protocol(ProtocolType.SOAP).as(LOGIN).userSteps.clientsStepsV5()
                .clientsGet(new GetRequestMap().withFieldNames(fieldNames));
        assertThat("в ответе массив с одним объектом и запрошенными полями в нем", getResponse.getClients()
                , beanDiffer(Arrays.asList(new ClientGetItem())).useCompareStrategy(strategy));
    }
}
