package ru.yandex.autotests.directapi.clients.get;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import com.yandex.direct.api.v5.clients.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balanceclient.NotifyCashback2JSONRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.ClientFakeInfo;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.math.RoundingMode.DOWN;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-128511")
@Description("Проверки получения поля Bonuses")
public class GetBonusesTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void init() {
        String client = ClientsLogins.SINGLE_CLIENT_RUB;
        ClientFakeInfo fakeInfo = api.userSteps.clientFakeSteps().getClientData(client);
        NotifyCashback2JSONRequest request = new NotifyCashback2JSONRequest()
                .withClientID(Long.valueOf(fakeInfo.getClientID()))
                .withBalanceCurrency(Currency.RUB.value())
                .withServiceId(7)
                .withCashbackBonus(BigDecimal.ZERO)
                .withCashbackConsumedBonus(BigDecimal.ZERO);
        log.info("Вызываем метод NotifyClientCashback - сбросим значение ожидающего кешбэка клиенту " + client);
        api.userSteps.getDarkSideSteps().getBalanceClientNotifyCashbackJsonSteps().notifyCashbackNoErrors(request);
    }

    @Test
    public void getBonuses_noCashback() {
        GetResponse getResponse = api.as(ClientsLogins.SINGLE_CLIENT_RUB)
                .userSteps.clientsStepsV5().clientsGet(
                        new GetRequestMap().withFieldNames(ClientFieldEnum.BONUSES));

        assertThat("У клиента ненулевой ожидающий кешбэк",
                getResponse.getClients().get(0).getBonuses().getAwaitingBonus(),
                equalTo(0L));
    }

    @Test
    public void getBonuses() {
        String client = ClientsLogins.SINGLE_CLIENT_RUB;
        ClientFakeInfo fakeInfo = api.userSteps.clientFakeSteps().getClientData(client);
        NotifyCashback2JSONRequest request = new NotifyCashback2JSONRequest()
                .withClientID(Long.valueOf(fakeInfo.getClientID()))
                .withBalanceCurrency(Currency.RUB.value())
                .withServiceId(7)
                .withCashbackBonus(BigDecimal.TEN)
                .withCashbackConsumedBonus(BigDecimal.ZERO);
        log.info("Вызываем метод NotifyClientCashback - выставим значение ожидающего кешбэка клиенту " + client);
        api.userSteps.getDarkSideSteps().getBalanceClientNotifyCashbackJsonSteps().notifyCashbackNoErrors(request);

        GetResponse getResponse = api.as(client)
                .userSteps.clientsStepsV5().clientsGet(new GetRequestMap().withFieldNames(ClientFieldEnum.BONUSES));

        assertThat("У клиента неожиданный кешбэк",
                getResponse.getClients().get(0).getBonuses().getAwaitingBonus(),
                equalTo(10_000_000L));
    }
}
