package ru.yandex.autotests.directapi.clients.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import com.yandex.direct.api.v5.clients.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ClientsAllowCreateScampBySubclient;
import ru.yandex.autotests.direct.db.steps.ClientsSteps;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientTypeEnum;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by alexteut on 28.09.16.
 */
@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-53855")
@Description("API5: Clients.Get Проверить возвращаемый Type")
@RunWith(Parameterized.class)
public class GetClientTypeTest {
    @Parameterized.Parameter(0)
    public String comment;

    @Parameterized.Parameter(1)
    public String operatorLogin;

    @Parameterized.Parameter(2)
    public String clientLogin;

    @Parameterized.Parameter(3)
    public ClientsAllowCreateScampBySubclient isFree;

    @Parameterized.Parameter(4)
    public ClientTypeEnum clientType;

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameters(name = "comment - {0}, operatorLogin - {1}, clientLogin - {2}, isFree - {3}, clientType - {4}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {
                        "Проверяем тип клиента из-под клиента",
                        ClientsLogins.SINGLE_CLIENT_RUB,
                        ClientsLogins.SINGLE_CLIENT_RUB,
                        ClientsAllowCreateScampBySubclient.No,
                        ClientTypeEnum.CLIENT
                },
                {
                        "Проверяем тип субклиента из-под агентства",
                        ClientsLogins.AGENCY_SH2,
                        ClientsLogins.AGENCY_SH2_SUBCLIENT,
                        ClientsAllowCreateScampBySubclient.No,
                        ClientTypeEnum.SUBCLIENT
                },
                {
                        "Проверяем тип субклиента из-под клиента",
                        ClientsLogins.AGENCY_SH2_SUBCLIENT,
                        ClientsLogins.AGENCY_SH2_SUBCLIENT,
                        ClientsAllowCreateScampBySubclient.No,
                        ClientTypeEnum.SUBCLIENT
                },
                {
                        "Проверяем тип агентства из-под агентства",
                        ClientsLogins.LOGIN_AGENCY,
                        ClientsLogins.LOGIN_AGENCY,
                        null,
                        ClientTypeEnum.AGENCY
                },
                {
                        "Проверяем тип агентства из-под супера",
                        ClientsLogins.SUPER_LOGIN,
                        ClientsLogins.LOGIN_AGENCY,
                        null,
                        ClientTypeEnum.AGENCY
                },
                {
                        "Проверяем тип агентства из-под супера",
                        ClientsLogins.SUPER_LOGIN,
                        ClientsLogins.LOGIN_AGENCY_REP1,
                        null,
                        ClientTypeEnum.AGENCY
                },
        });
    }

    private static Long longIdForLogin(String login) {
        return Long.valueOf(User.get(login).getClientID());
    }

    @Before
    public void init() {
        final long clientId = longIdForLogin(clientLogin);
        final int shard = api.userSteps.clientFakeSteps().getUserShard(clientLogin);
        final DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        final ClientsSteps jooqClientSteps = directJooqDbSteps.clientsSteps();
        if (isFree != null) {
            jooqClientSteps.setFree(clientId, isFree);
        }
    }

    @Test
    public void getClientTypeTest() {
        GetResponse getResponse = api.as(Logins.SUPER_READER, operatorLogin)
                .userSteps.clientsStepsV5().clientsGet(
                        new GetRequestMap().withFieldNames(ClientFieldEnum.TYPE),
                        clientLogin);

        assertThat("получили правильный тип",
                getResponse.getClients().get(0).getType(),
                equalTo(clientType.toString()));
    }
}
