package ru.yandex.autotests.directapi.clients.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import com.yandex.direct.api.v5.clients.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.EmailSubscriptionEnum;
import com.yandex.direct.api.v5.generalclients.EmailSubscriptionItem;
import com.yandex.direct.api.v5.generalclients.Notification;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.EmailSubscriptionItemMap;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by alexteut on 16.09.16.
 * https://st.yandex-team.ru/TESTIRT-10267
 */
@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-57687")
@Description("Проверка выдачи поля Notification")
@RunWith(Parameterized.class)
public class GetEmailSubscriptionsNotificationTest {
    private static final String LOGIN = ClientsLogins.LOGIN_EMAIL_SUBSCRIBE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public static String isSendNews;

    @Parameterized.Parameter(1)
    public static String isSendAccNews;

    @Parameterized.Parameter(2)
    public static String isSendWarn;

    @Parameterized.Parameters(name = "isSendNews = {0}, isSendAccNews = {1}, isSendWarn = {2}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Value.YES, Value.NO, Value.NO},  // EmailSubscriptionEnum.RECEIVE_RECOMMENDATIONS,
                {Value.NO, Value.YES, Value.NO},  // EmailSubscriptionEnum.TRACK_MANAGED_CAMPAIGNS
                {Value.NO, Value.NO, Value.YES},  // EmailSubscriptionEnum.TRACK_POSITION_CHANGES
        });
    }

    @Test
    public void getNotificationTest() {
        // Изменить значения подписок
        api.userSteps.clientSteps().updateClientInfo(new ClientInfoMap(api.type())
                .withLogin(LOGIN)
                .withFIO("Тест Тест")
                .withEmail("at-direct-clients-email-subs@yandex.ru")
                .withPhone(ClientInfoMap.DEFAULT_PHONE)
                .withSendNews(isSendNews)
                .withSendAccNews(isSendAccNews)
                .withSendWarn(isSendWarn));

        // Запросить подписки
        GetResponse getResponse = api.userSteps.clientsStepsV5().clientsGet(
                new GetRequestMap().withFieldNames(ClientFieldEnum.NOTIFICATION));

        Notification notification = getResponse.getClients().get(0).getNotification();

        List<EmailSubscriptionItem> subscriptionItemMaps = Arrays.asList(
                (EmailSubscriptionItem) (new EmailSubscriptionItemMap(EmailSubscriptionEnum.RECEIVE_RECOMMENDATIONS,
                        YesNoEnum.fromValue(isSendNews.toUpperCase()))).getBean(),
                (EmailSubscriptionItem) (new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_MANAGED_CAMPAIGNS,
                        YesNoEnum.fromValue(isSendAccNews.toUpperCase()))).getBean(),
                (EmailSubscriptionItem) (new EmailSubscriptionItemMap(EmailSubscriptionEnum.TRACK_POSITION_CHANGES,
                        YesNoEnum.fromValue(isSendWarn.toUpperCase()))).getBean()
        );

        assertThat("полученные подписки совпадают с ожидаемыми", notification.getEmailSubscriptions()
                , beanDifferV5(subscriptionItemMaps));
    }
}
