package ru.yandex.autotests.directapi.clients.get;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


@Aqua.Test
@Features(ClientsFeatures.RIGHTS_CHECK)
@Issue("https://st.yandex-team.ru/DIRECT-65862")
public class GetFromUnknownUserTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(ClientsLogins.LOGIN_UNKNOWN_USER);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    public void getShouldReturnErrorWhenUserIsValidButNotConnectedToDirect() {
        api.userSteps.clientsStepsV5().expectErrorOnClientsGet(
                new GetRequestMap().withFieldNames(ClientFieldEnum.LOGIN),
                new Api5Error(513, Api5ErrorDetails.EMPTY_STRING)
        );
    }
}
