package ru.yandex.autotests.directapi.clients.get;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import com.yandex.direct.api.v5.clients.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.hasProperty;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-68059")
@Description("Проверки отсутствия дублирования разрешений в поле Grants")
public class GetGrantsRepeatingTest {
    // субклиент агенства, в котором есть несколько представителей агенства
    private static final String SUBCLIENT = ClientsLogins.LOGIN_SUBCLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    @Step("Подготовка тестовых данных")
    public void clear() {
        api.as(SUBCLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT);
    }

    @Test
    public void getGrantsTest() {
        GetResponse getResponse = api.userSteps.clientsStepsV5().clientsGet(
                new GetRequestMap().withFieldNames(ClientFieldEnum.GRANTS));
        // три поля это: TRANSFER_MONEY, EDIT_CAMPAIGNS, IMPORT_XLS
        assertThat("получено три поля Grants, соответствующих агенству",
                getResponse.getClients(),
                contains(hasProperty(ClientGetItemMap.GRANTS, hasSize(3))));
    }
}
