package ru.yandex.autotests.directapi.clients.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import com.yandex.direct.api.v5.clients.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.PrivilegeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientGetItemMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.GrantGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 10/02/16.
 * https://st.yandex-team.ru/TESTIRT-8440
 */
@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-49746")
@Description("Проверки получения поля Grants")
@RunWith(Parameterized.class)
public class GetGrantsTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String operator;
    @Parameterized.Parameter(1)
    public String client;
    @Parameterized.Parameter(2)
    public ClientGetItemMap expected;

    @Parameterized.Parameters(name = "Логин - {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.LOGIN_MAIN, Logins.LOGIN_MAIN, new ClientGetItemMap().withGrants(
                        new GrantGetItemMap()
                                .withPrivilege(PrivilegeEnum.EDIT_CAMPAIGNS)
                                .withValue(YesNoEnum.YES),
                        new GrantGetItemMap()
                                .withPrivilege(PrivilegeEnum.IMPORT_XLS)
                                .withValue(YesNoEnum.YES),
                        new GrantGetItemMap()
                                .withPrivilege(PrivilegeEnum.TRANSFER_MONEY)
                                .withValue(YesNoEnum.YES))
                },
                {ClientsLogins.MANAGER_DEFAULT, ClientsLogins.LOGIN_FOR_RUB, new ClientGetItemMap().withGrants(
                        new GrantGetItemMap()
                                .withPrivilege(PrivilegeEnum.EDIT_CAMPAIGNS)
                                .withValue(YesNoEnum.YES),
                        new GrantGetItemMap()
                                .withPrivilege(PrivilegeEnum.IMPORT_XLS)
                                .withValue(YesNoEnum.YES),
                        new GrantGetItemMap()
                                .withPrivilege(PrivilegeEnum.TRANSFER_MONEY)
                                .withValue(YesNoEnum.YES)
                )},
                {ClientsLogins.AGENCY_CAMPAIGNS, ClientsLogins.SUB_CLIENT_WITHOUT_EDIT_RIGHTS, new ClientGetItemMap()
                        .withGrants(
                        new GrantGetItemMap()
                                .withAgency(ClientsLogins.AGENCY_CAMPAIGNS)
                                .withPrivilege(PrivilegeEnum.EDIT_CAMPAIGNS)
                                .withValue(YesNoEnum.NO),
                        new GrantGetItemMap()
                                .withAgency(ClientsLogins.AGENCY_CAMPAIGNS)
                                .withPrivilege(PrivilegeEnum.IMPORT_XLS)
                                .withValue(YesNoEnum.NO),
                        new GrantGetItemMap()
                                .withAgency(ClientsLogins.AGENCY_CAMPAIGNS)
                                .withPrivilege(PrivilegeEnum.TRANSFER_MONEY)
                                .withValue(YesNoEnum.NO)
                )},
                {ClientsLogins.AGENCY_CAMPAIGNS, ClientsLogins.SUB_CLIENT_WITH_EDIT_RIGHTS, new ClientGetItemMap()
                        .withGrants(
                        new GrantGetItemMap()
                                .withAgency(ClientsLogins.AGENCY_CAMPAIGNS)
                                .withPrivilege(PrivilegeEnum.EDIT_CAMPAIGNS)
                                .withValue(YesNoEnum.YES),
                        new GrantGetItemMap()
                                .withAgency(ClientsLogins.AGENCY_CAMPAIGNS)
                                .withPrivilege(PrivilegeEnum.IMPORT_XLS)
                                .withValue(YesNoEnum.NO),
                        new GrantGetItemMap()
                                .withAgency(ClientsLogins.AGENCY_CAMPAIGNS)
                                .withPrivilege(PrivilegeEnum.TRANSFER_MONEY)
                                .withValue(YesNoEnum.NO)
                )}
        });
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void clear() {
        api.as(operator);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operator);
    }

    @Test
    public void getGrantsTest() {
        GetResponse getResponse = api.userSteps.clientsStepsV5().clientsGet(
                new GetRequestMap().withFieldNames(ClientFieldEnum.GRANTS), client);
        assertThat("полученные поля совпадают с ожидаемыми", getResponse.getClients()
                , beanDifferV5(Arrays.asList(expected.getBean())));
    }
}
