package ru.yandex.autotests.directapi.clients.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import com.yandex.direct.api.v5.clients.GetResponse;
import com.yandex.direct.api.v5.general.LangEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.UsersRecord;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by hmepas on 10/02/16.
 * https://st.yandex-team.ru/TESTIRT-9820
 */
@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-56296")
@Description("Проверка мэпинга users.lang в API Clients.get Notification.Lang")
@RunWith(Parameterized.class)
public class GetNotificationLangMappingTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private UsersRecord user;

    @Parameterized.Parameter
    public String login;

    @Parameterized.Parameter(1)
    public String currentUsersLangInDB;

    @Parameterized.Parameter(2)
    public LangEnum expectedLangFromAPI;

    @Parameterized.Parameters(name = "Логин - {0}, Lang - {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {ClientsLogins.LOGIN_LANG_UKRAINE, "ua", LangEnum.UK},
        });
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void clear() {
        api.as(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        user = api.userSteps.getDirectJooqDbSteps().useShardForLogin(login).usersSteps().getUser(login);
    }

    @Test
    public void langMappingTest() {
        assumeThat("поле users.lang в БД совпадает с желаемым", user.getLang(), equalTo(currentUsersLangInDB));

        GetResponse getResponse = api.userSteps.clientsStepsV5().clientsGet(
                new GetRequestMap().withFieldNames(ClientFieldEnum.NOTIFICATION));

        assertThat("полученные поля совпадают с ожидаемыми", getResponse.getClients().get(0).getNotification().getLang()
                , equalTo(expectedLangFromAPI));
    }
}
