package ru.yandex.autotests.directapi.clients.get;

import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import com.yandex.direct.api.v5.clients.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.balanceclient.NotifyClient2JSONRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.ClientFakeInfo;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 10/02/16.
 * https://st.yandex-team.ru/TESTIRT-8440
 */
@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-49746")
@Description("Проверки получения поля OverdraftSumAvailable")
@RunWith(Parameterized.class)
public class GetOverdraftTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Money overdraftLimit;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public Currency currency;

    @Parameterized.Parameters(name = "{0}")
    public static Collection logins() {
        Object[][] data = new Object[][]{
                {"Клиент RUB", ClientsLogins.SINGLE_CLIENT_RUB, ClientsLogins.SINGLE_CLIENT_RUB, Currency.RUB},
                {"Менеджер сервисируемого клиента RUB", ClientsLogins.MANAGER_DEFAULT, ClientsLogins.SRV_CLIENT_RUB
                        , Currency.RUB},
                {"Клиент BYN", ClientsLogins.CLIENT_BYN, ClientsLogins.CLIENT_BYN, Currency.BYN},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void prepareOverdraft() {
        api.as(operator);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operator);
        ClientFakeInfo fakeInfo = api.userSteps.clientFakeSteps().getClientData(client);
        overdraftLimit = Money.valueOf(MoneyCurrency.get(currency).getMinTransferAmount().floatValue(), currency);
        NotifyClient2JSONRequest request = new NotifyClient2JSONRequest().defaultParams()
                .withClientID(Long.valueOf(fakeInfo.getClientID()))
                .withTimestamp()
                .withOverdraftLimit(overdraftLimit.floatValue())
                .withOverdraftSpent(0f)
                .withClientCurrency(currency.value());

        log.info("Вызываем метод NotifyClient2 - выставим значение овердрафта клиенту " + client);
        api.userSteps.getDarkSideSteps().getBalanceClientNotifyClientJsonSteps().notifyClientNoErrors(request);
    }

    @Test
    public void getOverdraftTest() {
        GetResponse getResponse = api.userSteps.clientsStepsV5().clientsGet(
                new GetRequestMap().withFieldNames(ClientFieldEnum.OVERDRAFT_SUM_AVAILABLE), client);
        Long expectedOverdraft = overdraftLimit.subtractVAT().setScale(2, RoundingMode.DOWN).bidLong()
                .longValue();
        assertThat("в ответе массив из одного элемента с одним полем OverdraftSumAvailable "
                        + "значение которого совпадает с ожидаемым"
                , getResponse.getClients()
                , beanDiffer(Arrays.asList(
                        new ClientGetItemMap().withOverdraftAvailable(expectedOverdraft).getBean()
                ))
        );

    }
}
