package ru.yandex.autotests.directapi.clients.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import com.yandex.direct.api.v5.clients.GetResponse;
import com.yandex.direct.api.v5.general.RepresentativeRoleEnum;
import com.yandex.direct.api.v5.generalclients.Representative;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientGetItemMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.RepresentativeMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 10/02/16.
 * https://st.yandex-team.ru/TESTIRT-8440
 */
@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-49746")
@Description("Проверки получения поля Representatives")
@RunWith(Parameterized.class)
public class GetRepresentativesTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter
    public String login;
    @Parameterized.Parameter(1)
    public ClientGetItemMap expected;

    @Parameterized.Parameters(name = "Оператор - {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {ClientsLogins.SINGLE_CLIENT_RUB, new ClientGetItemMap().withRepresentatives(
                        new RepresentativeMap()
                                .withEmail("at-single-client3-rub@yandex.ru")
                                .withLogin(ClientsLogins.SINGLE_CLIENT_RUB)
                                .withRole(RepresentativeRoleEnum.CHIEF))
                },
                {ClientsLogins.CLIENT_FREE_YE_DEFAULT, new ClientGetItemMap().withRepresentatives(
                        new RepresentativeMap()
                                .withEmail("at-tester@yandex-team.ru")
                                .withLogin(ClientsLogins.CLIENT_FREE_YE_DEFAULT)
                                .withRole(RepresentativeRoleEnum.CHIEF),
                        new RepresentativeMap()
                                .withEmail("at-direct-rep-client@ya.ru")
                                .withLogin(ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP)
                                .withRole(RepresentativeRoleEnum.DELEGATE),
                        new RepresentativeMap()
                                .withEmail("ya@ya.ru")
                                .withLogin(ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP_2)
                                .withRole(RepresentativeRoleEnum.DELEGATE))
                },
                {ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP_2, new ClientGetItemMap().withRepresentatives(
                        new RepresentativeMap()
                                .withEmail("at-tester@yandex-team.ru")
                                .withLogin(ClientsLogins.CLIENT_FREE_YE_DEFAULT)
                                .withRole(RepresentativeRoleEnum.CHIEF)
                )},
                {ClientsLogins.LOGIN_AGENCY, new ClientGetItemMap().withRepresentatives(
                        new RepresentativeMap()
                                .withEmail("at-direct-agency-adm@yandex.ru")
                                .withLogin("at-direct-agency-adm")
                                .withRole(RepresentativeRoleEnum.DELEGATE),
                        new RepresentativeMap()
                                .withEmail("direct-autotets@yandex-team.ru")
                                .withLogin(ClientsLogins.LOGIN_AGENCY)
                                .withRole(RepresentativeRoleEnum.CHIEF),
                        new RepresentativeMap()
                                .withEmail("test-agency-rub-rep1@yandex.ru")
                                .withLogin(ClientsLogins.LOGIN_AGENCY_REP1)
                                .withRole(RepresentativeRoleEnum.LIMITED)
                )},
                {ClientsLogins.LOGIN_AGENCY_REP1, new ClientGetItemMap().withRepresentatives(
                        new RepresentativeMap()
                                .withEmail("direct-autotets@yandex-team.ru")
                                .withLogin(ClientsLogins.LOGIN_AGENCY)
                                .withRole(RepresentativeRoleEnum.CHIEF)
                )},
                {ClientsLogins.AGENCY_YE_DEFAULT, new ClientGetItemMap().withRepresentatives(
                        new RepresentativeMap()
                                .withEmail("petr@yandex.мояфирма.рф")
                                .withLogin(ClientsLogins.AGENCY_YE_DEFAULT)
                                .withRole(RepresentativeRoleEnum.CHIEF),
                        new RepresentativeMap()
                                .withEmail("at-direct-ag-rep@yandex.ru")
                                .withLogin(ClientsLogins.AGENCY_YE_DEFAULT_REP_3)
                                .withRole(RepresentativeRoleEnum.LIMITED),
                        new RepresentativeMap()
                                .withEmail("at-direct-ag-rep@yandex.ru")
                                .withLogin(ClientsLogins.AGENCY_YE_DEFAULT_REP_4)
                                .withRole(RepresentativeRoleEnum.LIMITED),
                        new RepresentativeMap()
                                .withEmail("ya@ya.ru")
                                .withLogin(ClientsLogins.AGENCY_YE_DEFAULT_REP_2)
                                .withRole(RepresentativeRoleEnum.DELEGATE),
                        new RepresentativeMap()
                                .withEmail("at-direct-ag-rep@yandex.ru")
                                .withLogin(ClientsLogins.AGENCY_YE_DEFAULT_REP)
                                .withRole(RepresentativeRoleEnum.DELEGATE)
                )},
        });
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void clear() {
        api.as(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
    }

    @Test
    public void getRepresentativesTest() {
        GetResponse getResponse = api.userSteps.clientsStepsV5().clientsGet(
                new GetRequestMap().withFieldNames(ClientFieldEnum.REPRESENTATIVES));

        // представители могут приходить в разном порядке, нужно отсортировать.
        getResponse.getClients().get(0).getRepresentatives().sort(Comparator.comparing(Representative::getLogin));
        assertThat("полученные поля совпадают с ожидаемыми",
                getResponse.getClients(),
                beanDifferV5(Collections.singletonList(expected.getBean())));
    }
}
