package ru.yandex.autotests.directapi.clients.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by buhter on 10/02/16.
 * https://st.yandex-team.ru/TESTIRT-8440
 */
@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-49746")
@Description("Проверки для ролей, негативные проверки")
@RunWith(Parameterized.class)
public class GetRolesNegativeTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String operator;

    @Parameterized.Parameter(1)
    public String client;

    @Parameterized.Parameter(2)
    public Api5Error api5Error;

    @Parameterized.Parameters(name = "Оператор - {0}, клиент - {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {ClientsLogins.MANAGER_DEFAULT, null, error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {ClientsLogins.MEDIA, null, error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {ClientsLogins.PLACER, null, error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {ClientsLogins.SUPER_LOGIN, null, error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {ClientsLogins.SUPER_READER, null, error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {ClientsLogins.SUPPORT, null, error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {ClientsLogins.SUPER_LOGIN, ClientsLogins.MANAGER_DEFAULT,
                        error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {ClientsLogins.SUPER_LOGIN, ClientsLogins.SUPER_LOGIN,
                        error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {ClientsLogins.SUPER_LOGIN, ClientsLogins.MEDIA,
                        error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {ClientsLogins.SUPER_LOGIN, ClientsLogins.PLACER,
                        error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {ClientsLogins.SUPER_LOGIN, ClientsLogins.SUPER_READER,
                        error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {ClientsLogins.SUPER_LOGIN, ClientsLogins.SUPPORT,
                        error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {ClientsLogins.SINGLE_CLIENT_RUB, ClientsLogins.SUPER_LOGIN,
                        error(8000, Api5ErrorDetailsJava.NOT_CLIENT_IN_CLIENT_LOGIN)},
                {ClientsLogins.SINGLE_CLIENT_RUB, ClientsLogins.SRV_CLIENT_RUB,
                        error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)},
                {ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP_2, ClientsLogins.CLIENT_FREE_YE_DEFAULT,
                        error(54, Api5ErrorDetails.NO_RIGHTS_TO_THIS_USER)},
                {ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP_2, ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP,
                        error(54, Api5ErrorDetails.NO_RIGHTS_TO_THIS_USER)},
                {ClientsLogins.LOGIN_AGENCY_REP1, ClientsLogins.LOGIN_AGENCY,
                        error(54, Api5ErrorDetails.NO_RIGHTS_TO_THIS_USER)},
        });
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void clear() {
        api.as(operator);
    }

    @Test
    public void getNoClientTest() {
        api.userSteps.clientsStepsV5().expectErrorOnClientsGet(
                new GetRequestMap().withFieldNames(ClientFieldEnum.LOGIN),
                client,
                api5Error
        );
    }

    private static Api5Error error(int code, Api5ErrorDetails detail) {
        return new Api5Error(code, detail);
    }
    private static Api5Error error(int code, Api5ErrorDetailsJava detail) {
        return new Api5Error(code, detail);
    }
}
