package ru.yandex.autotests.directapi.clients.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import com.yandex.direct.api.v5.clients.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 10/02/16.
 * https://st.yandex-team.ru/TESTIRT-8440
 */
@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-49746")
@Description("Проверки для ролей")
@RunWith(Parameterized.class)
public class GetRolesTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String operator;

    @Parameterized.Parameter(1)
    public String login;

    @Parameterized.Parameter(2)
    public String expectedLogin;

    @Parameterized.Parameters(name = "Оператор - {0}, клиент - {1}, ожидание - {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {ClientsLogins.CLIENT_FREE_YE_DEFAULT, ClientsLogins.CLIENT_FREE_YE_DEFAULT,
                        ClientsLogins.CLIENT_FREE_YE_DEFAULT},
                {ClientsLogins.CLIENT_FREE_YE_DEFAULT, null, ClientsLogins.CLIENT_FREE_YE_DEFAULT},
                {ClientsLogins.CLIENT_FREE_YE_DEFAULT, ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP_2,
                        ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP_2},
                {ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP_2, ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP_2,
                        ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP_2},
                {ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP_2, null, ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP_2},
                {ClientsLogins.MANAGER_DEFAULT, ClientsLogins.LOGIN_FOR_RUB, ClientsLogins.LOGIN_FOR_RUB},
                {ClientsLogins.LOGIN_AGENCY, ClientsLogins.LOGIN_SUBCLIENT, ClientsLogins.LOGIN_SUBCLIENT},
                {ClientsLogins.LOGIN_FOR_RUB, ClientsLogins.LOGIN_FOR_RUB, ClientsLogins.LOGIN_FOR_RUB},
                {ClientsLogins.MEDIA, ClientsLogins.LOGIN_FOR_RUB, ClientsLogins.LOGIN_FOR_RUB},
                {ClientsLogins.PLACER, ClientsLogins.LOGIN_FOR_RUB, ClientsLogins.LOGIN_FOR_RUB},
                {ClientsLogins.SUPER_LOGIN, ClientsLogins.LOGIN_FOR_RUB, ClientsLogins.LOGIN_FOR_RUB},
                {ClientsLogins.SUPER_READER, ClientsLogins.LOGIN_FOR_RUB, ClientsLogins.LOGIN_FOR_RUB},
                {ClientsLogins.SUPPORT, ClientsLogins.LOGIN_FOR_RUB, ClientsLogins.LOGIN_FOR_RUB},

                {ClientsLogins.LOGIN_AGENCY, null, ClientsLogins.LOGIN_AGENCY},
                {ClientsLogins.LOGIN_AGENCY_REP1, null, ClientsLogins.LOGIN_AGENCY_REP1},
                {ClientsLogins.LOGIN_AGENCY, ClientsLogins.LOGIN_AGENCY_REP1, ClientsLogins.LOGIN_AGENCY_REP1},
                {ClientsLogins.MANAGER_DEFAULT, ClientsLogins.LOGIN_AGENCY, ClientsLogins.LOGIN_AGENCY},
                {ClientsLogins.SUPER_READER, ClientsLogins.LOGIN_AGENCY, ClientsLogins.LOGIN_AGENCY},
                {ClientsLogins.SUPER_LOGIN, ClientsLogins.LOGIN_AGENCY_REP1, ClientsLogins.LOGIN_AGENCY_REP1},
                {ClientsLogins.SUPPORT, ClientsLogins.LOGIN_AGENCY, ClientsLogins.LOGIN_AGENCY},
        });
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void clear() {
        api.as(operator);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operator);
    }

    @Test
    public void getForRolesTest() {
        GetResponse getResponse = api.userSteps.clientsStepsV5().clientsGet(
                new GetRequestMap().withFieldNames(ClientFieldEnum.LOGIN),
                login
        );
        assertThat("полученные поля совпадают с ожидаемыми", getResponse.getClients(),
                beanDifferV5(singletonList(new ClientGetItemMap().withLogin(expectedLogin).getBean())));
    }
}
