package ru.yandex.autotests.directapi.clients.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import com.yandex.direct.api.v5.clients.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.generalclients.ClientGetItem;
import com.yandex.direct.api.v5.generalclients.ClientSettingGetEnum;
import com.yandex.direct.api.v5.generalclients.ClientSettingGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.ClientsOptionsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.UsersRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientGetItemMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientSettingGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.db.steps.ClientsOptionsSteps.ClientFlagsEnum;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 10/02/16.
 * https://st.yandex-team.ru/TESTIRT-8440
 */

@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-49746")
@Description("Проверки получения поля Settings")
@RunWith(Parameterized.class)
public class GetSettingsTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(Logins.LOGIN_SUPER);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameter(1)
    public YesNoEnum sharedAccountEnabled;

    @Parameterized.Parameter(2)
    public YesNoEnum displayStoreRating;

    @Parameterized.Parameter(3)
    public YesNoEnum correctTyposAutomatically;

    private List<Object> expectedResult;

    @Parameterized.Parameters(name = "login {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.LOGIN_TRANSPORT_IMG_WIDE, YesNoEnum.NO, YesNoEnum.NO, YesNoEnum.NO},
                {Logins.LOGIN_WALLET, YesNoEnum.YES, YesNoEnum.YES, YesNoEnum.YES}
        });
    }

    @Before
    public void clear() {
        api.as(login);

        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(login);
        UsersRecord usersRecord = jooqDbSteps.usersSteps().getUser(login);
        ClientsOptionsRecord clientsOptionsRecord = new ClientsOptionsRecord()
                .setClientid(usersRecord.getClientid())
                .setHideMarketRating(displayStoreRating.equals(YesNoEnum.YES) ? 0 : 1)
                .setClientFlags(correctTyposAutomatically.equals(YesNoEnum.YES) ? ""
                        : ClientFlagsEnum.NO_TEXT_AUTOCORRECTION.toString());
        jooqDbSteps.clientsOptionsSteps().updateClientOptions(clientsOptionsRecord);

        expectedResult = Collections.singletonList(
                new ClientGetItemMap().withSettings(
                        new ClientSettingGetItemMap().withOption(ClientSettingGetEnum.SHARED_ACCOUNT_ENABLED)
                                .withValue(sharedAccountEnabled),
                        new ClientSettingGetItemMap().withOption(ClientSettingGetEnum.DISPLAY_STORE_RATING)
                                .withValue(displayStoreRating),
                        new ClientSettingGetItemMap().withOption(ClientSettingGetEnum.CORRECT_TYPOS_AUTOMATICALLY)
                                .withValue(correctTyposAutomatically)).getBean()
        );

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
    }

    @Test
    public void getSettingsTest() {
        GetResponse getResponse =
                api.userSteps.clientsStepsV5().clientsGet(new GetRequestMap().withFieldNames(ClientFieldEnum.SETTINGS));

        List<ClientGetItem> actualResult = getResponse.getClients();
        actualResult.forEach(e -> e.getSettings().sort(Comparator.comparing(ClientSettingGetItem::getOption)));

        expectedResult.forEach(
                e -> ((ClientGetItem) e).getSettings().sort(Comparator.comparing(ClientSettingGetItem::getOption)));

        assertThat("полученные поля совпадают с ожидаемыми", actualResult, beanDifferV5(expectedResult));
    }
}
