package ru.yandex.autotests.directapi.clients.get;

import java.util.Collection;

import com.yandex.direct.api.v5.clients.GetResponse;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-84978")
@Description("Проверки для представителя клиента с несколькими логинами")
@RunWith(Parameterized.class)
public class GetUidWithMultipleLoginsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameters(name = "Главный логин - {0}, дополнительный логин - {1}")
    public static Collection<Object[]> data() {
        return singletonList(
                new Object[] { "lilya_safonova@mail.ru", "lilya5afonova" }
        );
    }

    @Parameterized.Parameter(0)
    public String mainLogin;

    @Parameterized.Parameter(1)
    public String additionalLogin;

    @Test
    public void clientsGet_UserWithMultipleLogins_CheckByMainLogin_NoErrors() {
        GetResponse response = api.clientLogin(mainLogin).userSteps.clientsStepsV5()
                .clientsGet(new GetRequestMap().withAllFieldNames());

        assertThat(response.getClients(), hasSize(1));
        assertThat(response.getClients().get(0).getLogin(), is(mainLogin));
    }

    @Test
    public void clientsGet_UserWithMultipleLogins_CheckByAdditionalLogin_NoErrors() {
        GetResponse response = api.clientLogin(additionalLogin).userSteps.clientsStepsV5()
                .clientsGet(new GetRequestMap().withAllFieldNames());

        assertThat(response.getClients(), hasSize(1));
        assertThat(response.getClients().get(0).getLogin(), is(mainLogin));
    }
}
