package ru.yandex.autotests.directapi.clients.get;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 10/02/16.
 * https://st.yandex-team.ru/TESTIRT-8440
 */
@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-49746")
@Description("Проверки списания баллов")
public class GetUnitsTest {
    private static final String LOGIN = ClientsLogins.DISCOUNT_CLIENT;
    private static final String PARAMS = "params";
    private static final int CALL_COST = 10;
    private static final int COMMON_REQUEST_ERROR = 50;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();


    @Before
    @Step("Подготовка тестовых данных")
    public void clear() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void successGetUnitsTest() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.clientsStepsV5().clientsGet(new GetRequestMap().withFieldNames(ClientFieldEnum.LOGIN));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        assertThat("списалось правильное количество баллов", unitsBefore - unitsAfter, equalTo(CALL_COST));
    }

    @Test
    public void successGetWithSeveralFieldsUnitsTest() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.clientsStepsV5().clientsGet(new GetRequestMap().withFieldNames(
                ClientFieldEnum.LOGIN,
                ClientFieldEnum.CLIENT_INFO,
                ClientFieldEnum.SETTINGS
        ));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        assertThat("списалось правильное количество баллов", unitsBefore - unitsAfter, equalTo(CALL_COST));
    }

    @Test
    public void errorGetUnitsTest() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.clientsStepsV5().expectErrorOnClientsGet(new GetRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES)));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        assertThat("списалось правильное количество баллов", unitsBefore - unitsAfter, equalTo(COMMON_REQUEST_ERROR));
    }

}
