package ru.yandex.autotests.directapi.clients.get;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import com.yandex.direct.api.v5.clients.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.generalclients.ClientGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by buhter on 10/02/16.
 * https://st.yandex-team.ru/TESTIRT-8440
 */
@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-49746")
@Description("Проверки получения поля VATRate")
@RunWith(Parameterized.class)
public class GetVatTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(ClientsLogins.SUPER_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameter(1)
    public BigDecimal expectedVATRate;

    @Parameterized.Parameters(name = "{0} - VAT = {1}")
    public static Collection logins() {
        Object[][] data = new Object[][]{
                {ClientsLogins.LOGIN_VAT, BigDecimal.valueOf(0).setScale(0)},
                {ClientsLogins.LOGIN_VAT1, BigDecimal.valueOf(12).setScale(0)},
                {ClientsLogins.LOGIN_VAT2, BigDecimal.valueOf(18).setScale(0)},
                {ClientsLogins.LOGIN_AGENCY, BigDecimal.valueOf(20).setScale(0)}
        };
        return Arrays.asList(data);
    }

    @Before
    public void prepareVat() {
        api.as(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        if (expectedVATRate != null) {
            api.userSteps.clientFakeSteps().setVATRate(login, expectedVATRate.doubleValue());
        }
    }

    @Test
    public void getVatTest() {
        GetResponse getResponse = api.userSteps.clientsStepsV5().clientsGet(
                new GetRequestMap().withFieldNames(ClientFieldEnum.VAT_RATE));
        assertThat("полученное поле VATRate совпадает с ожидаемым"
                , getResponse.getClients()
                , beanDifferV5(Arrays.asList(new ClientGetItemMap().withVatRate(expectedVATRate).getBean())));
    }
}
