package ru.yandex.autotests.directapi.clients.get;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by buhter on 10/02/16.
 * https://st.yandex-team.ru/TESTIRT-8440
 */
@Aqua.Test
@Features(ClientsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-49746")
@Description("Вызов без поля FieldNames")
@RunWith(Parameterized.class)
public class GetWithoutFieldNamesTest {

    private static final String LOGIN = Logins.LOGIN_MAIN;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public ProtocolType protocolType;

    @Parameterized.Parameters(name = "Протокол - {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"JSON", ProtocolType.JSON},
                {"SOAP", ProtocolType.SOAP}
        });
    }

    @BeforeClass
    public static void clear() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void noFieldNamesTest() {
        api = new ApiSteps().version(104).protocol(protocolType).as(LOGIN);
        api.userSteps.clientsStepsV5().expectErrorOnClientsGet(new GetRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES)));
    }
}
