package ru.yandex.autotests.directapi.clients.update;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.clients.UpdateResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.model.api5.clients.ClientUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.clients.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.hasProperty;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/DIRECT-64582
 */
@Aqua.Test
@Features(ClientsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-62304")
@Description("Проверка прав доступа")
@RunWith(Parameterized.class)
public class CheckRightsPositiveTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operatorLogin;

    @Parameterized.Parameter(2)
    public String clientLogin;

    @Parameterized.Parameters(name = "{0} (operatorLogin = {1}, clientLogin = {2})")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][]{
                {"Обычный клиент может обновлять свои данные",
                        ClientsLogins.SINGLE_CLIENT_RUB, ClientsLogins.SINGLE_CLIENT_RUB},

                {"Главный представитель клиента может меня свои данные",
                        ClientsLogins.CLIENT_FREE_YE_DEFAULT, ClientsLogins.CLIENT_FREE_YE_DEFAULT},
                {"Главный представитель клиента может меня данные не главного",
                        ClientsLogins.CLIENT_FREE_YE_DEFAULT, ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP},
                {"Не главный представитель может менять свои данные",
                        ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP_2, ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP_2},

                // пока выключено https://st.yandex-team.ru/DIRECT-64582
//                {"Главный представитель агенства может менять свои данные",
//                        ClientsLogins.AGENCY_YE_DEFAULT, ClientsLogins.AGENCY_YE_DEFAULT},
//                {"Главный представитель агенства может менять данные не главного",
//                        ClientsLogins.AGENCY_YE_DEFAULT, ClientsLogins.AGENCY_YE_DEFAULT_REP},
//                {"Не главный представитель агенства может менять свои данные",
//                        ClientsLogins.AGENCY_YE_DEFAULT_REP, ClientsLogins.AGENCY_YE_DEFAULT_REP},
//                {"Менеджер может менять данные главного представителя агенства",
//                        ClientsLogins.MANAGER_DEFAULT, ClientsLogins.AGENCY_YE_DEFAULT},
//                {"Менеджер может менять данные не главного представителя агенства",
//                        ClientsLogins.MANAGER_DEFAULT, ClientsLogins.AGENCY_YE_DEFAULT_REP},
//                {"Представитель сапорта может менять данные главного представителя агенства",
//                        ClientsLogins.SUPPORT, ClientsLogins.AGENCY_YE_DEFAULT},
//                {"Представитель сапорта может менять данные не главного представителя агенства",
//                        ClientsLogins.SUPPORT, ClientsLogins.AGENCY_YE_DEFAULT_REP},

                {"Менеджер может менять данные обычного клиента",
                        ClientsLogins.MANAGER_DEFAULT, ClientsLogins.SRV_CLIENT_RUB},

                {"Представитель сапорта может менять данные обычного клиента",
                        ClientsLogins.SUPPORT, ClientsLogins.SINGLE_CLIENT_RUB},
                {"Представитель сапорта может менять данные не главного представителя клиента",
                        ClientsLogins.SUPPORT, ClientsLogins.CLIENT_FREE_YE_DEFAULT_REP},
                {"Представитель сапорта может менять данные субклиента агенства",
                        ClientsLogins.SUPPORT, ClientsLogins.LOGIN_SUBCLIENT},

                {"Супер может менять данные обычного клиента",
                        ClientsLogins.SUPER_LOGIN, ClientsLogins.SINGLE_CLIENT_RUB},
        });
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void clear() {
        api.as(operatorLogin);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operatorLogin);
    }

    @Test
    public void rolesTest() {
        UpdateResponse response = api.userSteps.clientsStepsV5().clientsUpdate(
                new UpdateRequestMap().withClients(new ClientUpdateItemMap()),
                clientLogin);
        assertThat("Обновление прошло успешно", response.getUpdateResults(),
                is(contains(hasProperty("clientId", notNullValue()))));
    }
}
