package ru.yandex.autotests.directapi.clients.update;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.UsersRecord;
import ru.yandex.autotests.direct.db.steps.UsersSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.clients.ClientsFeatures;
import ru.yandex.autotests.directapi.clients.ClientsLogins;
import ru.yandex.autotests.directapi.model.api5.clients.ClientUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.clients.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/DIRECT-64047
 */
@Aqua.Test
@Features(ClientsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-62304")
@Description("Проверка успешного обновления")
public class SuccessUpdateTest {
    private static final String LOGIN = ClientsLogins.LOGIN_UPDATE;

    public static final String FIO_BEFORE = "Апдейт Клиентов";
    public static final String FIO_NEW = "Сакцес Апдейтов";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private UsersSteps usersSteps;

    @Before
    @Step("Подготовка тестовых данных")
    public void prepare() {
        usersSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).usersSteps();
        UsersRecord usersRecord = usersSteps.getUser(LOGIN);
        usersRecord.setFio(FIO_BEFORE);
        usersSteps.updateUsers(usersRecord);
    }

    @Test
    public void successUpdateFioTest() {
        api.userSteps.clientsStepsV5().clientsUpdate(
                new UpdateRequestMap().withClients(new ClientUpdateItemMap<>().withClientInfo(FIO_NEW)));
        String fioAfterUpdate = usersSteps.getUser(LOGIN).getFio();
        assertThat("имя пользователя изменилось на новое", fioAfterUpdate, equalTo(FIO_NEW));
    }
}
