package ru.yandex.autotests.directapi.dictionaries.get.negative;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.dictionaries.DictionariesLogins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by proxeter on 10.02.16.
 */
@Aqua.Test
@Features(DictionariesFeatures.GET)
@Stories(ApiStories.UNITS)
@Description("Списание баллов при получении ошибочного словаря")
public class GetDictionariesInvalidUnitsTest {

    private static final String LOGIN = DictionariesLogins.INVALID_UNITS_LOGIN;
    private static final Integer DICTIONARIES_UNITS_COST = 50;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9591")
    public void getDictionariesInvalidUnits() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.dictionariesSteps().expectErrorOnDictionariesGet(
                new GetRequestMap().withDictionaryNames("invalid_dictionary"),
                JavaOrPerlApi5Error.java(
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.INCORRECT_ENUMERATE_VALUE_IN_ARRAY,
                                capitalize(GetRequestMap.DICTIONARY_NAMES),
                                "Currencies, MetroStations, GeoRegions, TimeZones, Constants, AdCategories, "
                                        + "OperationSystemVersions, ProductivityAssertions, SupplySidePlatforms, "
                                        + "Interests, AudienceCriteriaTypes, AudienceDemographicProfiles, "
                                        + "AudienceInterests, FilterSchemas"))
                        .perl(
                                new Api5Error(8000,
                                        Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                                        capitalize(GetRequestMap.DICTIONARY_NAMES))));

        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);

        assertThat("списалось правильное количество баллов", unitsAfter,
                equalTo(unitsBefore - DICTIONARIES_UNITS_COST));
    }

}
