package ru.yandex.autotests.directapi.dictionaries.get.negative;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.dictionaries.DictionariesLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by proxeter on 26.01.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8316
 */
@Aqua.Test
@Title("Получение словарей с указанием неправильного значения параметра")
@Features(DictionariesFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-41252")
@RunWith(Parameterized.class)
public class GetDictionariesWithInvalidRequestParameterTest {

    private static final String LOGIN = DictionariesLogins.DICTIONARIES_LOGIN;
    private static final String AGENCY_LOGIN = Logins.AGENCY_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String name;

    private JavaOrPerlApi5Error error = JavaOrPerlApi5Error.java(
            new Api5Error(8000,
                    Api5ErrorDetailsJava.INCORRECT_ENUMERATE_VALUE_IN_ARRAY,
                    capitalize(GetRequestMap.DICTIONARY_NAMES),
                    "Currencies, MetroStations, GeoRegions, TimeZones, Constants, AdCategories, "
                            + "OperationSystemVersions, ProductivityAssertions, SupplySidePlatforms, Interests, "
                            + "AudienceCriteriaTypes, AudienceDemographicProfiles, AudienceInterests, FilterSchemas"))
            .perl(
                    new Api5Error(8000,
                            Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                            capitalize(GetRequestMap.DICTIONARY_NAMES)));

    @Parameterized.Parameters(name = "dictionaryName = {0}, error = {1}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                { "" },
                { "invalid_dictionary" }
        });
    }

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9592")
    public void getDictionariesWithIvalidRequest() {
        api.userSteps.dictionariesSteps().expectErrorOnDictionariesGet(
                new GetRequestMap().withDictionaryNames(name),
                error
        );
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-64794")
    @ru.yandex.qatools.allure.annotations.TestCaseId("9592")
    public void getDictionariesWithInvalidRequestNoClientLogin() {
        api.as(AGENCY_LOGIN).userSteps.dictionariesSteps().expectErrorOnDictionariesGet(
                new GetRequestMap().withDictionaryNames(name),
                error
        );
    }
}
