package ru.yandex.autotests.directapi.dictionaries.get.positive;

import com.yandex.direct.api.v5.dictionaries.AdCategoriesItem;
import com.yandex.direct.api.v5.dictionaries.DictionaryNameEnum;
import com.yandex.direct.api.v5.dictionaries.GetResponse;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.dictionaries.DictionariesLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by proxeter on 25.01.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8316
 */
@Aqua.Test
@Title("Получение всех словарей")
@Tag(TagDictionary.TRUNK)
@Features(DictionariesFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-41252")
@RunWith(Parameterized.class)
public class GetAllDictionariesProtocolsTest {

    private static final String LOGIN = DictionariesLogins.DICTIONARIES_LOGIN;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public ProtocolType protocol;

    @Parameterized.Parameters(name = "protocol = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][] {
                { ProtocolType.JSON },
                { ProtocolType.SOAP }
        });
    }

    private static GetResponse dictionaries;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        dictionaries = api.userSteps.dictionariesSteps().getDictionaries(
                new GetRequestMap().withDictionaryNames(DictionaryNameEnum.values())
        );

        assumeThat("ответ пришел", dictionaries, notNullValue());
    }

    @Before
    public void before() {
        api.protocol(protocol);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9594")
    public void getAdCategories() {
        assertThat("категории присутствуют", dictionaries.getAdCategories(), hasSize(greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9593")
    public void getConstants() {
        assertThat("константы присутствуют", dictionaries.getConstants(), hasSize(greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9595")
    public void getCurrencies() {
        assertThat("валюты присутствуют", dictionaries.getCurrencies(), hasSize(greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9596")
    public void getGeoRegions() {
        assertThat("регионы присутствуют", dictionaries.getGeoRegions(), hasSize(greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9597")
    public void getMetroStations() {
        assertThat("станции метро присутствуют", dictionaries.getMetroStations(), hasSize(greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9598")
    public void getOSVersions() {
        assertThat("версии ОС присутствуют", dictionaries.getOperationSystemVersions(), hasSize(greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9599")
    public void getProductivityAssertions() {
        assertThat("рекомендации присутствуют", dictionaries.getProductivityAssertions(), empty());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9600")
    public void getTimeZones() {
        assertThat("временные зоны присутствуют", dictionaries.getTimeZones(), hasSize(greaterThan(0)));
    }

}
