package ru.yandex.autotests.directapi.dictionaries.get.positive;

import java.util.Collection;

import com.yandex.direct.api.v5.dictionaries.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;

/**
 * https://st.yandex-team.ru/TESTIRT-11004
 */
@Aqua.Test
@Title("Получение словарей под различными ролями не должно приводить к ошибке")
@Features(DictionariesFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-56753")
@RunWith(Parameterized.class)
public class GetDictionariesByRolesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String loginAuth;

    @Parameterized.Parameter(value = 1)
    public String loginClient;

    @Parameterized.Parameters(name = "{0}-{1}")
    public static Collection data() {
        return asList(new Object[][] {
                {Logins.AGENCY_YE_DEFAULT, null},
                {Logins.AGENCY_YE_DEFAULT, Logins.AGENCY_YE_DEFAULT},
                {Logins.AGENCY_YE_DEFAULT, Logins.CLIENT_FREE_YE_DEFAULT},
                {Logins.AGENCY_YE_DEFAULT, Logins.API_SUBCLIENT},
                {Logins.CLIENT_FREE_YE_DEFAULT, null},
                {Logins.CLIENT_FREE_YE_DEFAULT, Logins.CLIENT_FREE_YE_DEFAULT},
                {Logins.MEDIA, null},
                {Logins.SUPER_LOGIN, null},
                {Logins.SUPER_READER, null},
                {Logins.SUPPORT, null},
                {Logins.PLACER, null},
                {Logins.MANAGER_DEFAULT, null},
                {Logins.SUB_CLIENT_WITH_EDIT_RIGHTS, null},
                {Logins.SERVICED_CLIENT_IN_2_SHARD, null}
        });
    }

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginAuth);
        if (loginClient != null && loginClient != loginAuth ) {
            api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginClient);
        }
    }

    @Test
    public void getDictionariesByRole() {
        api.as(loginAuth);

        GetResponse response = api.userSteps.dictionariesSteps().getDictionaries(
                new GetRequestMap().withAllFieldNames(), loginClient);
        assertThat("Не было ошибки при вызове метода/вернулся корректный результат",
                response.getConstants(), hasSize(greaterThan(0)));
    }
}
