package ru.yandex.autotests.directapi.dictionaries.get.positive;

import com.yandex.direct.api.v5.dictionaries.DictionaryNameEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.dictionaries.DictionariesLogins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by proxeter on 10.02.16.
 */
@Aqua.Test
@Features(DictionariesFeatures.GET)
@Stories(ApiStories.UNITS)
@Description("Списание баллов при получении словарей")
@RunWith(Parameterized.class)
public class GetDictionariesUnitsTest {

    private static final String LOGIN = DictionariesLogins.UNITS_LOGIN;
    private static final Integer DICTIONARIES_UNITS_COST = 1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public GetRequestMap requestMap;

    @Parameterized.Parameters(name = "{0}")
    public static Collection data() {
        return Arrays.asList(new Object[][] {
                { new GetRequestMap().withDictionaryNames(DictionaryNameEnum.AD_CATEGORIES) },
                { new GetRequestMap().withDictionaryNames(DictionaryNameEnum.CONSTANTS) },
                { new GetRequestMap().withDictionaryNames(DictionaryNameEnum.CURRENCIES) },
                { new GetRequestMap().withDictionaryNames(DictionaryNameEnum.GEO_REGIONS) },
                { new GetRequestMap().withDictionaryNames(DictionaryNameEnum.METRO_STATIONS) },
                { new GetRequestMap().withDictionaryNames(DictionaryNameEnum.OPERATION_SYSTEM_VERSIONS) },
                { new GetRequestMap().withDictionaryNames(DictionaryNameEnum.PRODUCTIVITY_ASSERTIONS) },
                { new GetRequestMap().withDictionaryNames(DictionaryNameEnum.TIME_ZONES) },
                { new GetRequestMap().withAllFieldNames() },
        });
    }

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9601")
    public void getDictionariesUnits() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);
        api.userSteps.dictionariesSteps().getDictionaries(requestMap);
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(LOGIN);

        assertThat("списалось правильное количество баллов", unitsAfter, equalTo(unitsBefore - DICTIONARIES_UNITS_COST));
    }

}
