package ru.yandex.autotests.directapi.dictionaries.get.positive.adCategories;

import com.yandex.direct.api.v5.dictionaries.*;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.dictionaries.DictionariesLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by proxeter on 25.01.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8316
 */
@Aqua.Test
@Title("Получение словаря операций с группой объявлений")
@Features(DictionariesFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-41252")
public class GetAdCategoriesDictionaryTest {

    private static final String LOGIN = DictionariesLogins.DICTIONARIES_LOGIN;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private List<AdCategoriesItem> adCategoriesItems;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        GetResponse dictionaries = api.userSteps.dictionariesSteps().getDictionaries(
                new GetRequestMap().withDictionaryNames(DictionaryNameEnum.AD_CATEGORIES)
        );

        adCategoriesItems = dictionaries.getAdCategories();

        assumeThat("получен словарь операций с группой объявлений", adCategoriesItems, hasSize(greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9604")
    public void getAdCategories() {
        List<String> adCategories =
                adCategoriesItems.stream().map(AdCategoriesItem::getAdCategory).collect(Collectors.toList());

        assertThat("категории присутствуют", adCategories, everyItem(not(isEmptyOrNullString())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9603")
    public void getMessages() {
        List<String> messages =
                adCategoriesItems.stream().map(AdCategoriesItem::getMessage).collect(Collectors.toList());

        assertThat("сообщения присутствуют", messages, everyItem(not(isEmptyOrNullString())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9605")
    public void getDescriptions() {
        List<String> descriptions =
                adCategoriesItems.stream().map(AdCategoriesItem::getDescription).collect(Collectors.toList());

        assertThat("описания присутствуют", descriptions, everyItem(not(isEmptyOrNullString())));
    }

}
