package ru.yandex.autotests.directapi.dictionaries.get.positive.audience;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.dictionaries.AudienceDemographicProfilesItem;
import com.yandex.direct.api.v5.dictionaries.DictionaryNameEnum;
import com.yandex.direct.api.v5.dictionaries.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.Locale;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.dictionaries.DictionariesLogins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Title("Получение элемента словаря поведенческих признаков")
@Features(DictionariesFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-80726")
@RunWith(Parameterized.class)
public class GetAudienceDemographicProfiles {

    private static final String LOGIN = DictionariesLogins.DICTIONARIES_LOGIN;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String locale;
    @Parameterized.Parameter(value = 1)
    public String name;
    @Parameterized.Parameter(value = 2)
    public String description;
    @Parameterized.Parameter(value = 3)
    public Long id;
    @Parameterized.Parameter(value = 4)
    public String type;

    private AudienceDemographicProfilesItem expectedProfile;

    @Parameterized.Parameters(name = "locale {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Locale.RUSSIAN.getName(), "Мужчины",
                        "Мужчины. Пол определяется по поведению в интернете.", 2499000001L, "GENDER"},
                {Locale.RUSSIAN.getName(), "Пользуются смартфонами на Android",
                        "Люди, которые используют смартфоны на Android.", 2499000246L, "DEVICES"},
                {Locale.ENGLISH.getName(), "Male",
                        "Male. Gender is determined by online behavior.", 2499000001L, "GENDER"},
                {Locale.ENGLISH.getName(), "Use Android smartphones",
                        "People who use Android smartphones.", 2499000246L, "DEVICES"},
        });
    }

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        expectedProfile = new AudienceDemographicProfilesItem();
        expectedProfile.setId(id);
        expectedProfile.setName(name);
        expectedProfile.setType(type);
        expectedProfile.setDescription(description);
    }

    @Test
    public void getDemographicProfile() {
        GetResponse dictionaries = api.locale(locale).userSteps.dictionariesSteps().getDictionaries(
                new GetRequestMap().withDictionaryNames(DictionaryNameEnum.AUDIENCE_DEMOGRAPHIC_PROFILES));
        List<AudienceDemographicProfilesItem> audienceProfiles = dictionaries.getAudienceDemographicProfiles();
        assumeThat("получен словарь таргетингов по аудитории", audienceProfiles, notNullValue());
        assertThat("таргетинг присутствует", audienceProfiles, hasItem(expectedProfile));
    }
}
