package ru.yandex.autotests.directapi.dictionaries.get.positive.geoRegions;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

import com.yandex.direct.api.v5.dictionaries.DictionaryNameEnum;
import com.yandex.direct.api.v5.dictionaries.GeoRegionsItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.Locale;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by onotole on 9/28/16.
 * https://st.yandex-team.ru/TESTIRT-10304
 */
@Aqua.Test
@Description("проверяем добавление новых стран в Европу")
@Stories(ApiStories.GEO)
@Features(DictionariesFeatures.GET)
@RunWith(Parameterized.class)
public class CheckMovedToEuropeCountryTest {
    private static String europeName = "Europe";
    private static Optional<Long> europeId;
    private static List<GeoRegionsItem> regions;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.CLIENT_FOR_RUB);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String countryName;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return Arrays.asList(new Object[][]{
                {"Portugal"},
                {"Romania"}
        });
    }

    @BeforeClass
    public static void setUp() {
        regions = api.locale(Locale.ENGLISH.getName()).userSteps.dictionariesSteps().getDictionaries(new GetRequestMap()
                .withDictionaryNames(
                        DictionaryNameEnum.GEO_REGIONS
                )).getGeoRegions();
        europeId = regions.stream().filter((p) -> p.getGeoRegionName().equals(europeName)).map(GeoRegionsItem::getGeoRegionId).findFirst();
        assumeThat("Европа нашлась в dictionary", europeId.isPresent(), equalTo(true));
    }

    @Test
    public void isThisCountryInEurope() {
        Optional<Long> countryParentId = regions.stream().filter((p) -> p.getGeoRegionName().equals(countryName)).map(GeoRegionsItem::getParentId).findFirst();
        assumeThat("Страна нашлась в dictionary", countryParentId.isPresent(), equalTo(true));
        assertThat("страна " + countryName + " входит в Европу", countryParentId, equalTo(europeId));
    }
}
