package ru.yandex.autotests.directapi.dictionaries.get.positive.geoRegions;

import com.yandex.direct.api.v5.dictionaries.DictionaryNameEnum;
import com.yandex.direct.api.v5.dictionaries.GeoRegionsItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.model.common.RemovedRegionIDValues;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Collection;
import java.util.List;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by onotole on 9/30/16.
 * https://st.yandex-team.ru/TESTIRT-10304
 */
@Aqua.Test
@Description("проверяем что удаленные регионы не возвращаются через Dictionaries.get")
@Stories(ApiStories.GEO)
@Features(DictionariesFeatures.GET)
@RunWith(Parameterized.class)
public class CheckRemovedRegionsTest {
    private static List<GeoRegionsItem> regions;

    @Parameterized.Parameter(0)
    public Long geoRegionId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> testData() {
        return RemovedRegionIDValues.values;
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.CLIENT_FOR_RUB);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void setUp() {
        regions = api.userSteps.dictionariesSteps().getDictionaries(new GetRequestMap()
                .withDictionaryNames(
                        DictionaryNameEnum.GEO_REGIONS)).getGeoRegions();
    }

    @Test
    public void checkRemovedRegionIdInDictionary() {
        assertThat("удаленный регион отсутствует в ответе Dictionaries.get",
                regions.stream().filter((p) -> p.getGeoRegionId() == geoRegionId).count(),
                equalTo(0L));
    }
}
