package ru.yandex.autotests.directapi.dictionaries.get.positive.geoRegions;

import com.yandex.direct.api.v5.dictionaries.DictionaryNameEnum;
import com.yandex.direct.api.v5.dictionaries.GeoRegionsItem;
import com.yandex.direct.api.v5.dictionaries.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.dictionaries.DictionariesLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by proxeter on 25.01.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8316
 */
@Aqua.Test
@Title("Получение словаря регионов")
@Features(DictionariesFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-41252")
public class GetGeoRegionsDictionaryTest {

    private static final String LOGIN = DictionariesLogins.DICTIONARIES_LOGIN;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private List<GeoRegionsItem> regions;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        GetResponse dictionaries = api.userSteps.dictionariesSteps().getDictionaries(
                new GetRequestMap().withDictionaryNames(DictionaryNameEnum.GEO_REGIONS)
        );

        regions = dictionaries.getGeoRegions();

        assumeThat("получен словарь регионов", regions, hasSize(greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9614")
    public void getGeoRegionIds() {
        List<Long> geoRegionIds = regions.stream().map(GeoRegionsItem::getGeoRegionId).collect(Collectors.toList());

        assertThat("идентификаторы регионов присутствуют", geoRegionIds, everyItem(notNullValue(Long.class)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9615")
    public void getGeoRegionNames() {
        List<String> geoRegionNames =
                regions.stream().map(GeoRegionsItem::getGeoRegionName).collect(Collectors.toList());

        assertThat("наименования регионов присутствуют", geoRegionNames, everyItem(not(isEmptyOrNullString())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9616")
    public void getGeoRegionTypes() {
        List<String> geoRegionTypes =
                regions.stream().map(GeoRegionsItem::getGeoRegionType).collect(Collectors.toList());

        assertThat("типы регионов присутствуют", geoRegionTypes, everyItem(not(isEmptyOrNullString())));
    }

}
