package ru.yandex.autotests.directapi.dictionaries.get.positive.interests;

import com.yandex.direct.api.v5.dictionaries.DictionaryNameEnum;
import com.yandex.direct.api.v5.dictionaries.GetResponse;
import com.yandex.direct.api.v5.dictionaries.InterestsItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.Locale;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.dictionaries.DictionariesLogins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by lightelfik on 15.11.16.
 *
 * https://st.yandex-team.ru/TESTIRT-10605
 */
@Aqua.Test
@Title("Получение элемента словаря интересов для РМП")
@Features(DictionariesFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-58365")
@RunWith(Parameterized.class)
public class GetInterestsDictionaryItemTest {

    private static final String LOGIN = DictionariesLogins.DICTIONARIES_LOGIN;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String locale;
    @Parameterized.Parameter(value = 1)
    public String name;

    @Parameterized.Parameters(name = "locale {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][] {
                { Locale.ENGLISH.getName(), "Games" },
                { Locale.RUSSIAN.getName(), "Игры" },
        });
    }


    private List<InterestsItem> interests;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        GetResponse dictionaries = api.locale(locale).userSteps.dictionariesSteps().getDictionaries(
                new GetRequestMap().withDictionaryNames(DictionaryNameEnum.INTERESTS)
        );

        assumeThat("получен словарь интересов", dictionaries.getInterests(), notNullValue());

        interests = dictionaries.getInterests();

    }

    @Test
    public void getInterestsItem() {
        InterestsItem interest = new InterestsItem();
        interest.setInterestId(81);
        interest.setParentId(null);
        interest.setName(name);
        interest.setIsTargetable(YesNoEnum.NO);

        assertThat("интерес присутствует", interests, hasItem(interest));
    }

}
