package ru.yandex.autotests.directapi.dictionaries.get.positive.interests;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.dictionaries.DictionaryNameEnum;
import com.yandex.direct.api.v5.dictionaries.GetResponse;
import com.yandex.direct.api.v5.dictionaries.InterestsItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.TargetingCategoriesRecord;
import ru.yandex.autotests.direct.utils.model.Locale;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.dictionaries.DictionariesLogins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.toMap;
import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertTrue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Title("Получение элемента словаря интересов для РМП")
@Features(DictionariesFeatures.GET)
@RunWith(Parameterized.class)
public class GetInterestsLocalizationTest {

    private static final String LOGIN = DictionariesLogins.DICTIONARIES_LOGIN;
    private static Map<Long, String> categoriesMap;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String locale;

    @Parameterized.Parameters(name = "locale {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][] {
                { Locale.ENGLISH.getName()},
                { Locale.RUSSIAN.getName()},
                { Locale.TURKEY.getName()},
        });
    }

    private List<InterestsItem> interests;

    @BeforeClass
    public static void createCampaignAndAdGroup() {
        categoriesMap = api.userSteps.getDirectJooqDbSteps().interestSteps().getTargetingCategoriesRecords().stream()
                .collect(toMap(TargetingCategoriesRecord::getCategoryId, TargetingCategoriesRecord::getOriginalName));
    }

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        GetResponse dictionaries = api.locale(locale).userSteps.dictionariesSteps().getDictionaries(
                new GetRequestMap().withDictionaryNames(DictionaryNameEnum.INTERESTS)
        );

        assumeThat("получен словарь интересов по локализации", dictionaries.getInterests(), notNullValue());

        interests = dictionaries.getInterests();
    }

    @Test
    public void allInterestsHaveLocalizedName() {

        //В тестовой базе в таблицу "retargeting_conditions" постоянно добавляются тестовые записи с префиксом "test", отбрасываем их.
        //Для всех прочих записей должен быть перевод.
        //То есть значение из словаря должно отличаться от поля targeting_categories.original_name в базе.
        //Если перевода нет, то танкер вернет значение ключа, которое берется из этого поля.
        List<InterestsItem> wrongLocaleInterests = interests.stream()
                .filter(item -> !item.getName().contains("test") && !item.getName().contains("TEST"))
                .filter(item -> categoriesMap.get(item.getInterestId()).equals(item.getName()))
                .collect(Collectors.toList());

        assertTrue("Все интересы локализованы", wrongLocaleInterests.isEmpty());
    }

}
