package ru.yandex.autotests.directapi.dictionaries.get.positive.metrostations;

import com.yandex.direct.api.v5.dictionaries.DictionaryNameEnum;
import com.yandex.direct.api.v5.dictionaries.GetResponse;
import com.yandex.direct.api.v5.dictionaries.MetroStationsItem;
import com.yandex.direct.api.v5.dictionaries.TimeZonesItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.dictionaries.DictionariesLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by proxeter on 25.01.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8316
 */
@Aqua.Test
@Title("Получение словаря станций метро")
@Features(DictionariesFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-41252")
public class GetMetroStationsDictionaryTest {

    private static final String LOGIN = DictionariesLogins.DICTIONARIES_LOGIN;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private List<MetroStationsItem> metroStations;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        GetResponse dictionaries = api.userSteps.dictionariesSteps().getDictionaries(
                new GetRequestMap().withDictionaryNames(DictionaryNameEnum.METRO_STATIONS)
        );

        metroStations = dictionaries.getMetroStations();

        assumeThat("получен словарь станций метро", metroStations, hasSize(greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9618")
    public void getGeoRegionIds() {
        List<Long> geoRegionIds =
                metroStations.stream().map(MetroStationsItem::getGeoRegionId).collect(Collectors.toList());

        assertThat("идентификаторы регионов присутствуют", geoRegionIds, everyItem(notNullValue(Long.class)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9619")
    public void getMetroStationIds() {
        List<Long> metroStationIds =
                metroStations.stream().map(MetroStationsItem::getMetroStationId).collect(Collectors.toList());

        assertThat("идентификаторы станций метро присутствуют", metroStationIds, everyItem(notNullValue(Long.class)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9620")
    public void getMetroStationNames() {
        List<String> metroStationNames =
                metroStations.stream().map(MetroStationsItem::getMetroStationName).collect(Collectors.toList());

        assertThat("наименования станций метро присутствуют", metroStationNames, everyItem(not(isEmptyOrNullString())));
    }

}
