package ru.yandex.autotests.directapi.dictionaries.get.positive.supplySidePlatforms;

import com.yandex.direct.api.v5.dictionaries.SupplySidePlatformsItem;
import com.yandex.direct.api.v5.dictionaries.DictionaryNameEnum;
import com.yandex.direct.api.v5.dictionaries.GetResponse;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.dictionaries.DictionariesLogins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.List;
import java.util.stream.Collectors;

import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by lightelfik on 06.03.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8985
 */
@Aqua.Test
@Title("Получение словарей с SSP площадками")
@Features(DictionariesFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-52160")
public class GetSupplySidePlatformsDictionaryTest {

    private static final String LOGIN = DictionariesLogins.DICTIONARIES_LOGIN;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static List<SupplySidePlatformsItem> platforms;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        GetResponse dictionaries = api.userSteps.dictionariesSteps().getDictionaries(
                new GetRequestMap().withDictionaryNames(DictionaryNameEnum.SUPPLY_SIDE_PLATFORMS)
        );
        platforms = dictionaries.getSupplySidePlatforms();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9629")
    public void getPlatforms() {

        assertThat("получен словарь с SSP площадками", platforms, hasSize(greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9628")
    public void getPlatformTitle() {

        List<String> platformTitles =
                platforms.stream().map(SupplySidePlatformsItem::getTitle).collect(Collectors.toList());

        assertThat("свойство 'название' присутствует", platformTitles, everyItem(not(isEmptyOrNullString())));
    }

}
