package ru.yandex.autotests.directapi.dictionaries.get.positive.timezones;

import com.yandex.direct.api.v5.dictionaries.DictionaryNameEnum;
import com.yandex.direct.api.v5.dictionaries.GetResponse;
import com.yandex.direct.api.v5.dictionaries.TimeZonesItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.dictionaries.DictionariesFeatures;
import ru.yandex.autotests.directapi.dictionaries.DictionariesLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.dictionaries.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.*;
import static org.hamcrest.Matchers.isEmptyOrNullString;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by proxeter on 25.01.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8316
 */
@Aqua.Test
@Title("Получение словаря часовых поясов")
@Features(DictionariesFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-41252")
public class GetTimezonesDictionaryTest {

    private static final String LOGIN = DictionariesLogins.DICTIONARIES_LOGIN;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private List<TimeZonesItem> timeZones;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        GetResponse dictionaries = api.userSteps.dictionariesSteps().getDictionaries(
                new GetRequestMap().withDictionaryNames(DictionaryNameEnum.TIME_ZONES)
        );

        timeZones = dictionaries.getTimeZones();

        assumeThat("получен словарь часовых поясов", timeZones, hasSize(greaterThan(0)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9631")
    public void getTimezones() {
        List<String> timeZones = this.timeZones.stream().map(TimeZonesItem::getTimeZone).collect(Collectors.toList());

        assertThat("часовые пояса присутствуют", timeZones, everyItem(not(isEmptyOrNullString())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9632")
    public void getTimezonesNames() {
        List<String> timeZoneNames =
                this.timeZones.stream().map(TimeZonesItem::getTimeZoneName).collect(Collectors.toList());

        assertThat("названия часовых поясов присутствуют", timeZoneNames, everyItem(not(isEmptyOrNullString())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9633")
    public void getUtcOffsets() {
        List<Integer> utcOffsets =
                this.timeZones.stream().mapToInt(TimeZonesItem::getUtcOffset).boxed().collect(Collectors.toList());

        assertThat("названия часовых поясов присутствуют", utcOffsets, everyItem(notNullValue(Integer.class)));
    }

}
