package ru.yandex.autotests.directapi.dynamictextadtargets.add;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.DynamicConditionsRecord;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static ru.yandex.autotests.direct.db.utils.JooqRecordDifferMatcher.recordDiffer;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies.onlyExpectedFields;

/**
 * Created by ginger on 27.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Features(DynamicTextAdTargetsFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-43826")
public class AddDBTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    private static Long pid;
    private static Long cid;
    private static int shard;
    private static Long webpageID;
    private BidsDynamicRecord bidsDynamicObject;
    private DynamicConditionsRecord dynamicConditionsObject;
    private static Money price = MoneyCurrency.get(Currency.RUB).getMinPrice().getNext();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        webpageID = api.userSteps.dynamicTextAdTargetsSteps().addWebpage(
                new WebpageAddItemMap()
                        .withAdGroupId(pid)
                        .withName("Name")
                        .withBid(price.bidLong().longValue())
                        .withConditions(
                                new WebpageConditionMap()
                                        .withArguments("картоха")
                                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                        )
        );
    }

    @Test
    public void addWebpageWithConditionCheckBidsDynamic() {
        dynamicConditionsObject = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .dynamicConditionsSteps()
                .getDynamicConditionByAdgroupId(pid);

        DynamicConditionsRecord expectedDynamicConditionObject = new DynamicConditionsRecord();
        expectedDynamicConditionObject.setDynCondId(webpageID);
        expectedDynamicConditionObject.setPid(pid);
        expectedDynamicConditionObject.setConditionName("Name");
        expectedDynamicConditionObject.setConditionJson("[{\"kind\":\"exact\",\"type\":\"content\",\"value\":[\"картоха\"]}]");
        assertThat("верно получен из базы объект DynamicConditions", dynamicConditionsObject,
                recordDiffer(expectedDynamicConditionObject).useCompareStrategy(onlyExpectedFields()));
    }

    @Test
    public void addWebpageWithConditionCheckDynamicConditions() {
        bidsDynamicObject = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsSteps()
                .getBidsDynamicByPid(pid)
                .get(0);
        BidsDynamicRecord expectedBidsDynamicObject = new BidsDynamicRecord();
        expectedBidsDynamicObject.setDynCondId(webpageID);
        expectedBidsDynamicObject.setPid(pid);
        expectedBidsDynamicObject.setPrice(price.bigDecimalValue().setScale(2));
        expectedBidsDynamicObject
                .setPriceContext(MoneyCurrency.get(Currency.RUB).getMinPrice().bigDecimalValue().setScale(2));
        expectedBidsDynamicObject.setAutobudgetpriority(3);
        expectedBidsDynamicObject.setOpts("");
        assertThat("верно получен из базы объект BidsDynamic", bidsDynamicObject,
                recordDiffer(expectedBidsDynamicObject).useCompareStrategy(onlyExpectedFields()));
    }
}
