package ru.yandex.autotests.directapi.dynamictextadtargets.add;

import java.util.Arrays;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 02.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
@Description("Попытка добавить условия нацеливания с невалидным AdGroupId")
@RunWith(Parameterized.class)
public class AddInvalidIdsTest {
    private static String client2 = DynamicTextAdTargetsLogins.SINGLE_CLIENT;
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;
    private static Long cid;
    private static Long pid;
    private static long nonExistPid;
    private static Long deletedCid;
    private static Long deletedPid;
    private static Long archiveCid;
    private static Long archivePid;
    private static long holodilnikGroupId;
    private static Long anotherClientCid;
    private static Long anotherClientPid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long adGroupId;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> data() {
        prepareData();
        return Arrays.asList(new Object[][]{
                {"Нулевой AdGroupId", 0L,
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                StringUtils.capitalize(WebpageAddItemMap.AD_GROUP_ID))))
                },
                {"Отрицательный AdGroupId", -1L,
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                StringUtils.capitalize(WebpageAddItemMap.AD_GROUP_ID))))},
                {"Несуществующая группа", nonExistPid,
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)
                                        .withDetails("Группа объявлений не найдена")))
                                .perl(ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)))},
                {"Удаленная группа", deletedPid,
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)
                                        .withDetails("Группа объявлений не найдена")))
                                .perl(ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)))},
                {"Чужая текстовая группа", holodilnikGroupId,
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)
                                        .withDetails("Группа объявлений не найдена")))
                                .perl(ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)))},  //Bug DIRECT-48403
                {"Чужая динамическая группа", anotherClientPid,
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)
                                        .withDetails("Группа объявлений не найдена")))
                                .perl(ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)))},
                {"Группа из архивной кампании", archivePid,
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(8300, Api5ErrorDetails.CAMPAIGN_ARCHIVED)
                                        .withDetails("Кампания помещена в архив")))
                                .perl(ExpectedResult.errors(new Notification(8300, Api5ErrorDetails.CAMPAIGN_ARCHIVED)))
                }  // Bug DIRECT-48415
        });
    }

    private static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(client);
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);

        nonExistPid = pid + 1000000;

        deletedCid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(client);
        api.userSteps.campaignFakeSteps().setType(deletedCid, CampaignsType.DYNAMIC);
        deletedPid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(deletedCid);
        api.userSteps.campaignFakeSteps().setType(deletedCid, CampaignsType.TEXT);
        api.userSteps.campaignSteps().campaignsDelete(deletedCid);

        archiveCid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(client);
        archivePid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(archiveCid);
        api.userSteps.campaignSteps().campaignsSuspend(archiveCid);
        api.userSteps.campaignSteps().campaignsArchive(archiveCid);

        holodilnikGroupId = 350l;

        api.as(client2);
        anotherClientCid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(client2);
        anotherClientPid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(anotherClientCid, client2);
        api.as(client);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client2);
    }

    @Test
    public void tryAddWebpagesWithInvalidAdGroupId() {
        api.as(client).userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withWebpages(
                        new WebpageAddItemMap()
                                .withConditions(new WebpageConditionMap()
                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                        .withArguments("ginger")
                                )
                                .withName("Name")
                                .withBid(30000000l)
                                .withAdGroupId(adGroupId)
                ),
                expectedResult
        );
    }
}
