package ru.yandex.autotests.directapi.dynamictextadtargets.add;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by buhter on 03/09/15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Features(DynamicTextAdTargetsFeatures.ADD)
@Description("Неправильный формат запроса")
@Issue("https://st.yandex-team.ru/DIRECT-43826")
public class AddJsonValidationTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;

    private static final String PARAMS = "params";

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD);
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
    }

    @Test
    public void invalidFieldInParams() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();

        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), adGroupId);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), 15f);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONTEXT_BID), 15f);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.STRATEGY_PRIORITY), PriorityEnum.LOW);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONDITIONS), new Object[]{new WebpageConditionMap()
                .withOperand(WebpageConditionOperandEnum.DOMAIN)
                .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                .withArguments("asdasdasdasd.com")
                .getBean()}
        );
        request.put(AddRequestMap.WEBPAGES, new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE, capitalize(AddRequestMap.WEBPAGES))
        );
    }

    @Test
    public void arrayInParams() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();

        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), adGroupId);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), 15f);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONTEXT_BID), 15f);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.STRATEGY_PRIORITY), PriorityEnum.LOW);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONDITIONS), new Object[]{new WebpageConditionMap()
                .withOperand(WebpageConditionOperandEnum.DOMAIN)
                .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                .withArguments("asdasdasdasd.com")
                .getBean()}
        );
        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                new Object[]{request},
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_REQUEST_FORMAT)
        );
    }

    @Test
    public void notArrayInWebpages() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();

        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), adGroupId);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), 15f);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONTEXT_BID), 15f);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.STRATEGY_PRIORITY), PriorityEnum.LOW);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONDITIONS), new Object[]{new WebpageConditionMap()
                .withOperand(WebpageConditionOperandEnum.DOMAIN)
                .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                .withArguments("asdasdasdasd.com")
                .getBean()}
        );
        request.put(capitalize(AddRequestMap.WEBPAGES), dynamicTextAdTargets);
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(AddRequestMap.WEBPAGES))
        );
    }

    @Test
    public void arrayInElementOfWebpages() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();

        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), adGroupId);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), 15);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONTEXT_BID), 15);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.STRATEGY_PRIORITY), PriorityEnum.LOW);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONDITIONS), new Object[]{new WebpageConditionMap()
                .withOperand(WebpageConditionOperandEnum.DOMAIN)
                .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                .withArguments("asdasdasdasd.com")
                .getBean()}
        );
        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{new Object[]{dynamicTextAdTargets}});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE,
                        capitalize(AddRequestMap.WEBPAGES))
        );
    }

    @Test
    public void invalidFieldInWebpages() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();

        dynamicTextAdTargets.put(WebpageAddItemMap.AD_GROUP_ID, adGroupId);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), 15f);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONTEXT_BID), 15f);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.STRATEGY_PRIORITY), PriorityEnum.LOW);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONDITIONS), new Object[]{new WebpageConditionMap()
                .withOperand(WebpageConditionOperandEnum.DOMAIN)
                .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                .withArguments("asdasdasdasd.com")
                .getBean()}
        );
        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.WEBPAGES), capitalize(WebpageAddItemMap.AD_GROUP_ID))
        );
    }


    @Test
    public void withoutAdGroupIdInWebpages() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();

        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), 3000000f);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONDITIONS), new Object[]{new WebpageConditionMap()
                .withOperand(WebpageConditionOperandEnum.DOMAIN)
                .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                .withArguments("asdasdasdasd.com")
                .getBean()}
        );
        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.WEBPAGES), capitalize(WebpageAddItemMap.AD_GROUP_ID))
        );
    }

    @Test
    public void notArrayInConditions() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();

        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), adGroupId);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), 1500000l);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONTEXT_BID), 1500000l);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.STRATEGY_PRIORITY), PriorityEnum.LOW);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONDITIONS), new WebpageConditionMap()
                .withOperand(WebpageConditionOperandEnum.DOMAIN)
                .withOperator(StringConditionOperatorEnum.NOT_CONTAINS_ALL)
                .withArguments("asdasdasdasd.com")
                .getBean()
        );
        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(capitalize(AddRequestMap.WEBPAGES),
                                capitalize(WebpageAddItemMap.CONDITIONS))));
    }

//    @Test
//    public void invalidFieldInTextAd() {
//        JSONObject request = new JSONObject();
//        JSONObject ad = new JSONObject();
//        JSONObject textAd = new JSONObject();
//        textAd.put(TextAdAddMap.TEXT, TextAdAddMap.DEFAULT_TEXT);
//        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
//        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
//        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
//        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
//        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
    // api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
//                request,
//                new Api5Error(8000, Api5ErrorDetails.FIELD_CONTAIN_UNKNOWN_FIELD,
//                        capitalize(AdAddItemMap.TEXT_AD), TextAdAddMap.TEXT)
//        );
//    }
}
