package ru.yandex.autotests.directapi.dynamictextadtargets.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 05.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
public class AddMandatoryFieldsTest {
    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long pid;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(LOGIN);
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
    }

    @Test
    @Description("Запрос без поля Webpages в запросе на добавление условий нацеливания")
    public void requestWithoutSelectionCriteria() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                new AddRequestMap().withWebpages(),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        capitalize(AddRequestMap.WEBPAGES), 1));
    }

    @Test
    @Description("Запрос без поля Webpages.AdGroupID в запросе на добавление условия нацеливания")
    public void requestWithoutName() {
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withAdGroupId(pid)
                                        .withBid(30000000l)),
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.WEBPAGES), capitalize(WebpageAddItemMap.NAME)));
    }

}
