package ru.yandex.autotests.directapi.dynamictextadtargets.add;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qa.balance.tools.common.utils.RandomDataUtils;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 09.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
public class AddNameTest {
    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;
    private static Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createTestData() {
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(LOGIN);
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
    }

    @Issue("DIRECT-48424")
    @Test
    public void addMoreThanMaxLengthName() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5001, Api5ErrorDetails.FIELD_VALUE_SHOULD_NOT_BE_MORE_THAN,
                                capitalize(WebpageAddItemMap.NAME), 100)
                                .withDetails("Значение в поле Name не должно превышать 100 символов"))
                )
                .perl(ExpectedResult.errors(
                        new Notification(5001, Api5ErrorDetails.FIELD_VALUE_SHOULD_NOT_BE_MORE_THAN,
                                capitalize(WebpageAddItemMap.NAME), 100))
                );

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName(RandomDataUtils.getRandomString(101))
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult);
    }

    @Test
    public void addMaxLengthName() {
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withConditions(
                                                new WebpageConditionMap()
                                                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                                        .withArguments(RandomDataUtils.getRandomString(10))
                                        )
                                        .withName(RandomDataUtils.getRandomString(100))
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                ExpectedResult.success()
        );
    }

    @Test
    public void addWithSpecificSymbolsInName() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5002,
                                Api5ErrorDetails.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                capitalize(WebpageAddItemMap.NAME))
                                .withDetails("В поле Name допускается использование букв латинского, турецкого, " +
                                        "русского, украинского, казахского, белорусского алфавитов, цифр и знаков " +
                                        "пунктуации"))
                )
                .perl(ExpectedResult.errors(
                        new Notification(5002,
                                Api5ErrorDetails.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                capitalize(WebpageAddItemMap.NAME)))
                );

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withName("サムライ")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult);
    }

    @Test
    public void addEmptyStringInName() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5000, Api5ErrorDetails.NO_VALUE_IN_FIELD, capitalize(WebpageAddItemMap.NAME))
                                .withDetails("Не указано значение в поле Name"))
                )
                .perl(ExpectedResult.errors(
                        new Notification(5000, Api5ErrorDetails.NO_VALUE_IN_FIELD, capitalize(WebpageAddItemMap.NAME)))
                );

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withName("")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult);
    }

    @Test
    public void addEmptyStringWithSomeSpaces() {

        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(
                        new Notification(5000, Api5ErrorDetails.NO_VALUE_IN_FIELD, capitalize(WebpageAddItemMap.NAME))
                                .withDetails("Не указано значение в поле Name"))
                )
                .perl(ExpectedResult.errors(
                        new Notification(5000, Api5ErrorDetails.NO_VALUE_IN_FIELD, capitalize(WebpageAddItemMap.NAME)))
                );

        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withWebpages(
                                new WebpageAddItemMap()
                                        .withName("    ")
                                        .withBid(30000000l)
                                        .withAdGroupId(pid)
                        ),
                expectedResult);
    }
}
