package ru.yandex.autotests.directapi.dynamictextadtargets.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 09.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
@Description("Добавление условия от имени внутренних ролей")
@RunWith(Parameterized.class)
public class AddRoleTest {
    private static LogSteps log = LogSteps.getLogger(AddRoleTest.class);

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String groupCreator;

    @Parameterized.Parameter(1)
    public String webpageCreator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;
    private Long pid;

    @Parameterized.Parameters(name = "group = {0}, webpage = {1}, client = {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.MANAGER_DEFAULT, Logins.MANAGER_DEFAULT, DynamicTextAdTargetsLogins.SERV_CLIENT,
                        ExpectedResult.success()},
                {Logins.SUPER_LOGIN, Logins.PLACER, DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD,
                        ExpectedResult.success()},
                {Logins.SUPER_LOGIN, Logins.SUPPORT, DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD,
                        ExpectedResult.success()},
                {Logins.SUPER_LOGIN, Logins.SUPER_LOGIN, DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD,
                        ExpectedResult.success()},
                {Logins.SUPER_LOGIN, DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD, DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD,
                        ExpectedResult.success()},
                {Logins.SUPER_LOGIN, DynamicTextAdTargetsLogins.SINGLE_CLIENT_REP, DynamicTextAdTargetsLogins.SINGLE_CLIENT,
                        ExpectedResult.success()},
                {DynamicTextAdTargetsLogins.AGENCY, DynamicTextAdTargetsLogins.AGENCY, DynamicTextAdTargetsLogins.SUBCLIENT,
                        ExpectedResult.success()},
                {DynamicTextAdTargetsLogins.AGENCY_REP, DynamicTextAdTargetsLogins.AGENCY_REP, DynamicTextAdTargetsLogins.SUBCLIENT,
                        ExpectedResult.success()},

                {Logins.SUPER_LOGIN, Logins.MEDIA, DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE))},
                {Logins.SUPER_LOGIN, Logins.SUPER_READER, DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE))},
                {DynamicTextAdTargetsLogins.AGENCY, DynamicTextAdTargetsLogins.SUBCLIENT, DynamicTextAdTargetsLogins.SUBCLIENT,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE))}
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        log.info("Сбросим использованные юниты");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(webpageCreator);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(groupCreator);

        log.info("Создадим кампанию и группу от имени " + groupCreator);
        api.as(groupCreator);
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(client);
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid, client);
    }

    @Test
    public void addRolesTest() {
        api.as(webpageCreator);
        api.userSteps.dynamicTextAdTargetsSteps().shouldGetResultOn(
                Action.ADD,
                client,
                new AddRequestMap().withWebpages(new WebpageAddItemMap()
                        .withAdGroupId(pid)
                        .withName("Name")
                        .withBid(30000000l)
                ),
                expectedResult);
    }
}
