package ru.yandex.autotests.directapi.dynamictextadtargets.add;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

/**
 * Created by gerdler on 12.08.16.
 * https://st.yandex-team.ru/TESTIRT-10036
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-55156")
@Features(DynamicTextAdTargetsFeatures.ADD)
@Description("Попытка добавить условия нацеливания в ДО-группу с фидом")
public class AddToDynamicTextFeedAdGroupTest {
    private static final String CLIENT = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(CLIENT).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(adGroupId, feedId);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void tryAddWebpagesToNotDynamicCampaign() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(new Notification(6001,
                        Api5ErrorDetails.INELIGIBLE_DYNAMIC_ADGROUP_SUBTYPE_FOR_WEBPAGES)
                        .withDetails("Условия нацеливания динамических текстовых объявлений разрешено добавлять " +
                                "только в группы объявлений с типом DYNAMIC_TEXT_AD_GROUP и подтипом WEBPAGE")))
                .perl(ExpectedResult.errors(new Notification(6001,
                        Api5ErrorDetails.INELIGIBLE_DYNAMIC_ADGROUP_SUBTYPE_FOR_WEBPAGES)));
        api.as(CLIENT).userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withWebpages(
                        new WebpageAddItemMap()
                                .withAdGroupId(adGroupId)
                                .withName("Name1")
                                .withBid(MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue())
                ),
                expectedResult);
    }
}
