package ru.yandex.autotests.directapi.dynamictextadtargets.add;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

/**
 * Created by ginger on 02.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@RunWith(Parameterized.class)
@Features(DynamicTextAdTargetsFeatures.ADD)
@Description("Попытка добавить условия нацеливания в нединамические кампании")
public class AddToNotDynamicAdGroupTest {
    private static String client = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;
    private static Long cid;
    private static Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public AdGroupType adGroupType;

    @Parameterized.Parameters(name = "Тип группы: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {AdGroupType.BASE},
                {AdGroupType.MOBILE_CONTENT}});
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        if (adGroupType == AdGroupType.BASE) {
            cid = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
            pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        } else if (adGroupType == AdGroupType.MOBILE_CONTENT) {
            cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(client);
            pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        }
    }

    @Test
    public void tryAddWebpagesToNotDynamicCampaign() {
        JavaOrPerlExpectedResult expectedResult = JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.INVALID_GROUP_TYPE)
                        .withDetails("Неверный тип группы")))
                .perl(ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.INVALID_GROUP_TYPE)));
        api.as(client).userSteps.dynamicTextAdTargetsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withWebpages(
                        new WebpageAddItemMap()
                                .withAdGroupId(pid)
                                .withName("Name1")
                                .withBid(300000l)
                ),
                expectedResult);
    }
}
