package ru.yandex.autotests.directapi.dynamictextadtargets.add;

import com.yandex.direct.api.v5.general.PriorityEnum;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsFeatures;
import ru.yandex.autotests.directapi.dynamictextadtargets.DynamicTextAdTargetsLogins;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 05.11.15.
 * https://st.yandex-team.ru/TESTIRT-6666
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43826")
@Features(DynamicTextAdTargetsFeatures.ADD)
public class AddWebpagesFieldTypesNegativeTest {
    private static final String LOGIN = DynamicTextAdTargetsLogins.SINGLE_CLIENT_ADD;
    private static Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createTestData() {
        Long cid = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
    }

    @Test
    public void invalidAdGroupIdType() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), WebpageAddItemMap.AD_GROUP_ID);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), 15000000f);

        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(capitalize(AddRequestMap.WEBPAGES), capitalize(WebpageAddItemMap.AD_GROUP_ID)))
        );
    }

    @Test
    public void invalidBidType() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), pid);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.BID), WebpageAddItemMap.BID);

        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(capitalize(AddRequestMap.WEBPAGES), capitalize(WebpageAddItemMap.BID)))
        );
    }

    @Test
    public void invalidContextBidype() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), pid);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.CONTEXT_BID), WebpageAddItemMap.CONTEXT_BID);

        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(capitalize(AddRequestMap.WEBPAGES), capitalize(WebpageAddItemMap.CONTEXT_BID)))
        );
    }

    @Test
    public void invalidPriorityType() {
        JSONObject request = new JSONObject();
        JSONObject dynamicTextAdTargets = new JSONObject();
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.AD_GROUP_ID), pid);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.NAME), WebpageAddItemMap.NAME);
        dynamicTextAdTargets.put(capitalize(WebpageAddItemMap.STRATEGY_PRIORITY), 15000000);

        request.put(capitalize(AddRequestMap.WEBPAGES), new Object[]{dynamicTextAdTargets});
        api.userSteps.dynamicTextAdTargetsSteps().expectErrorOnDynamicTextAdTargetsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.INCORRECT_ENUMERATE_VALUE,
                        path(capitalize(AddRequestMap.WEBPAGES), capitalize(WebpageAddItemMap.STRATEGY_PRIORITY)),
                        String.join(", ", PriorityEnum.LOW.value(), PriorityEnum.NORMAL.value(),
                                PriorityEnum.HIGH.value()))
        );
    }
}
